#!/bin/sh
#
# Copyright (c) 2002, PerfCap Corporation, Nashua NH
# All Rights Reserved
#
# New RPM for LINUX, + HP
#
# PerfCap Installation Script for AIX/SUN/TRU/HP/LINUX
#   fix for sun and 1020
#-------------------------------------------------------

ECAP_MONITOR_OPT=""
PAWZ_AGENT_OPT=""
PAWZ_REALTIME_OPT=""

KIT_MEDIA_ROOT="`pwd`"
KIT_OS_MEDIA_ROOT="`pwd`"

OS=`uname -s`
OSVER=`uname -v`
OSREL=`uname -r`
ECHO="echo"
ECHON="echo -n"
SUPPORTED_OS=0
SUPPORTED_OS_FOR_PLANNER=0
PLATFORM=""
PLAT=""
USE_ECHO_N=0
OWN="bin:bin"

#
# defaults
#
DEFAULT_INSTALLDIR=/usr/perfcap
DEFAULT_DC_SCAN="2000"
DEFAULT_DC_DUMP="120"
DEFAULT_DC_PEAK="0"
DEFAULT_AUG_NET="0"
DEFAULT_AUG_PROC="0"
DEFAULT_DC_RETAIN="30"
DEFAULT_PAWZAGENT_PORT="1661"
DEFAULT_PAWZAGENT_VERBOSE="0"

DEFAULT_PAWZRTA_PORT="2101"
DEFAULT_PAWZRTA_SCAN="2"
DEFAULT_PAWZRTA_PROC="0"
DEFAULT_PAWZRTA_ALERT="1"
DEFAULT_PAWZRTA_VERBOSE="0"

# 
# current Install (if any)
#

EXISTING_INSTALLDIR=""
EXISTING_DATADIR=""
#
#  WHAT WE are going to INSTALL
#
OPT_SILENT="0"
OPT_HELP="0"
OPT_HAVE_INSTALLDIR="0"
OPT_INSTALLDIR=""
OPT_HAVE_DATADIR="0"
OPT_DATADIR=""
OPT_HAVE_LICENSEDIR="0"
OPT_LICENSEDIR="`pwd`"
OPT_SAVE_DB="0"

# ecap

OPT_HAVE_DC_RETAIN="0"
OPT_DC_RETAIN=$DEFAULT_DC_RETAIN

OPT_HAVE_DC_SCAN="0"
OPT_DC_SCAN=$DEFAULT_DC_SCAN

OPT_HAVE_DUMP="0"
OPT_DUMP=$DEFAULT_DC_DUMP

OPT_HAVE_PEAK="0"
OPT_PEAK=$DEFAULT_DC_PEAK

OPT_HAVE_AUG_NET="0"
OPT_AUG_NET=$DEFAULT_AUG_NET

OPT_HAVE_AUG_PROC="0"
OPT_AUG_PROC=$DEFAULT_AUG_PROC

OPT_DC_HAVE_MAPDISK="0"
OPT_DC_MAPDISK=""

#pawz
OPT_HAVE_PAWZAGENT_PORT="0"
OPT_PAWZAGENT_PORT=$DEFAULT_PAWZAGENT_PORT
OPT_HAVE_PAWZAGENT_VERBOSE="0"
OPT_PAWZAGENT_VERBOSE=$DEFAULT_PAWZAGENT_VERBOSE
OPT_HAVE_PAWZAGENT_SERVER="0"
OPT_PAWZAGENT_SERVER="0.0.0.0"

OPT_HAVE_PAWZAGENT_APPDATADIR="0"
OPT_PAWZAGENT_APPDATADIR=""

OPT_HAVE_COMPRESSION="0"
OPT_PAWZAGENT_COMPRESSION=""

#rta
OPT_HAVE_PAWZRTA_PORT="0"
OPT_PAWZRTA_PORT=$DEFAULT_PAWZRTA_PORT
OPT_HAVE_PAWZRTA_SCAN="0"
OPT_PAWZRTA_SCAN=$DEFAULT_PAWZRTA_SCAN
OPT_HAVE_PAWZRTA_ALERT="0"
OPT_PAWZRTA_ALERT=$DEFAULT_PAWZRTA_ALERT
OPT_HAVE_PAWZRTA_PROC="0"
OPT_PAWZRTA_PROC=$DEFAULT_PAWZRTA_PROC
OPT_HAVE_PAWZRTA_VERBOSE="0"
OPT_PAWZRTA_VERBOSE=$DEFAULT_PAWZRTA_VERBOSE

LICENSEFILE_ECAP_REDUCER=""
LICENSEFILE_ECAP_MONITOR=""
LICENSEFILE_ECAP_ANALYZER=""
LICENSEFILE_ECAP_PLANNER=""

INSTALL_IS_REINSTALL=0
INSTALL_ALL=0
INSTALL_PLAN=0
INSTALL_AN=0
INSTALL_PP=0
INSTALL_RN=0
INSTALL_RT=0
INSTALL_DB=0
INSTALL_PAWZ=0
INSTALL_DC=0

HAVE_DIR=0
HAVE_LICENSE=0
LINKED_DEFAULT_INSTALLDIR=""
INSTALL_IS_LINK=0
PROCEED_INSTALL=1
INVALID_DIR=0
HAVE_DATA_DIR=0
HAVE_UNINSTALL=0
HOSTNAME=`hostname`
RPMKIT="pawz-9.2.0.0-1.x86_64.rpm"

#------------------------------------------
# Set Platform/System Specific defaults,
#--------------------------------------------

SetupEnv()
{
   if [ "$OS" = "AIX" ] 
   then
       ECHO="echo"
       DEFAULT_INSTALLDIR=/usr/perfcap
       SUPPORTED_OS=1
       HOSTNAME=`hostname -s`
       OSBITS=`/usr/sbin/bootinfo -K`

       if [ $OSBITS = "32" ]
       then
           KIT_OS_MEDIA_ROOT="`pwd`/aix32_53"
           if [ "$OSVER" = "4" ]
           then
               KIT_OS_MEDIA_ROOT="`pwd`/aix32"
           else
              if [ "$OSVER" = "5" ] && [ "$OSREL" = "0" ] 
               then
                  KIT_OS_MEDIA_ROOT="`pwd`/aix32"
              fi
              if [ "$OSVER" = "5" ] && [ "$OSREL" = "1" ] 
              then
                  KIT_OS_MEDIA_ROOT="`pwd`/aix32"
              fi
              if [ "$OSVER" = "5" ] && [ "$OSREL" = "2" ] 
              then
                  KIT_OS_MEDIA_ROOT="`pwd`/aix32"
              fi
           fi

       else
           KIT_OS_MEDIA_ROOT="`pwd`/aix64_53"

           if [ "$OSVER" = "5" ] && [ "$OSREL" = "0" ] 
           then
                  KIT_OS_MEDIA_ROOT="`pwd`/aix64"
           fi
           if [ "$OSVER" = "5" ] && [ "$OSREL" = "1" ] 
           then
                  KIT_OS_MEDIA_ROOT="`pwd`/aix64"
           fi
           if [ "$OSVER" = "5" ] && [ "$OSREL" = "2" ] 
           then
                  KIT_OS_MEDIA_ROOT="`pwd`/aix64"
           fi
       fi
#
# determin OS
#
       SUPPORTED_OS_FOR_PLANNER=1
       echo "AIX kit is $KIT_OS_MEDIA_ROOT"
   fi
   if [ "$OS" = "SunOS" ] 
   then
       ECHO="/usr/bin/echo"
       DEFAULT_INSTALLDIR=/opt/perfcap
       SUPPORTED_OS=1
       ARCH=`uname -m`

       if [ -x /usr/bin/isainfo ]
       then
           ISAINFO="`isainfo -b`"
       else
             ISAINFO="32"
       fi

       if [ "$ARCH"  = "i86pc" ]
       then
            if [ ${ISAINFO} = "64" ]
            then
               KIT_OS_MEDIA_ROOT="`pwd`/sun_i86pc64"
            else
               KIT_OS_MEDIA_ROOT="`pwd`/sun_i86pc32"
            fi
           SUPPORTED_OS_FOR_PLANNER=0

      else


        if [ ${ISAINFO} = "64" ]
        then
            KIT_OS_MEDIA_ROOT="`pwd`/sun64"
        else
            KIT_OS_MEDIA_ROOT="`pwd`/sun32"
        fi

       if [ "$OSREL" = "5.6" ]
       then
           SUPPORTED_OS_FOR_PLANNER=0
       else
           SUPPORTED_OS_FOR_PLANNER=1
       fi
      fi

   fi
   if [ "$OS" = "OSF1" ] 
   then
       ECHO="echo"
       DEFAULT_INSTALLDIR=/usr/opt/perfcap
       SUPPORTED_OS=1
       HOSTNAME=`hostname -s`
       KIT_OS_MEDIA_ROOT="`pwd`/tru"
       SUPPORTED_OS_FOR_PLANNER=1
   fi
   if [ "$OS" = "HP-UX" ] 
   then
       ECHO="echo"
       DEFAULT_INSTALLDIR=/opt/perfcap
       SUPPORTED_OS=1
       KIT_OS_MEDIA_ROOT="`pwd`/hpux"
       SUPPORTED_OS_FOR_PLANNER=1
        

       ARCH=`uname -m`
       if [ "$ARCH"  = "ia64" ]
       then
           KIT_OS_MEDIA_ROOT="`pwd`/hpux_ia64"
           SUPPORTED_OS_FOR_PLANNER=0
       else

           PLAT="`file /stand/vmunix | awk '{ print $9 }'`"
           if [ "$PLAT" = "(LP64)" ]
           then
               KIT_OS_MEDIA_ROOT="`pwd`/hpux64"
           else
               KIT_OS_MEDIA_ROOT="`pwd`/hpux32"
           fi


       fi
   fi
   if [ "$OS" = "Linux" ] 
   then
       ECHO="/bin/echo"
       DEFAULT_INSTALLDIR=/usr/local/perfcap
       SUPPORTED_OS=1
       USE_ECHO_N=1
       HOSTNAME=`hostname -s`
       if [ -d /proc/vmware ]
       then
         echo  "vmware media not found"
         exit 0 
       else
           ARCH=`uname -m`
           KIT_OS_MEDIA_ROOT="`pwd`"
           if [ "$ARCH"  = "ia64" ]
           then
                  echo "ia64 linux not supported with this media"
                  exit 0
           fi
           if [ "$ARCH"  = "x86_64" ]
           then
              if [ -f "/usr/X11R6/lib/libXt.so"  ]
              then
                  SUPPORTED_OS_FOR_PLANNER=1
	          RPMKIT="pawz-9.2.0.0-1_motif.x86_64.rpm"
              else
                  echo "Motif libraries not found!"
                  exit 0 
              fi 
           fi
           if [ "$ARCH"  = "i686" ] || [ "$ARCH"  = "i586" ] || [ "$ARCH"  = "i486" ] || [ "$ARCH"  = "i386" ]
           then
              if [ -f "/usr/X11R6/lib/libXt.so"  ]
              then
	          RPMKIT="pawz-9.2.0.0-1_motif.i386.rpm"
                  SUPPORTED_OS_FOR_PLANNER=1
              else
                  echo "Motif libraries not found!"
                  exit 0
              fi
           fi
       fi
   fi
  
   #----------------------------------------- 
   # COPYRIGHT 
   #------------------------------------------

   $ECHO " "
   $ECHO "PerfCap Software installation script"
   $ECHO "Copyright (c) 2001-2010, PerfCap Corporation, All Rights Reserved"
   $ECHO  "--------------------------------------------------------------"
   $ECHO " "
   $ECHO  " for silent install,  use -silent "
   $ECHO  " for information on command line options use  -help"
   $ECHO  " "

   if [ $SUPPORTED_OS -eq 0 ]
   then
       $ECHO " "
       $ECHO "$OS  is not supported by this media"
       exit 0
   fi
   #----------------------------------------- 
   #  Validate OS VERSION
   #------------------------------------------

   if [ "$OS" = "AIX" ] 
   then
        if test $OSVER -eq 4
        then
            if test $OSREL -ne 3
            then
               echo "  This kit only supports IBM AIX 4.3"
               exit 0
            fi
       elif test $OSVER -ne 5
       then
                echo "  This kit only supports IBM AIX 5.n"
                exit 0
       fi
   fi 

   # needed ?

   if [ "$OS" = "HP-UX" ]
   then

       if [ "$OSREL" = "B.10.20" ]
       then
          PLATFORM="1020"
       else

          ARCH=`uname -m`
          if [ "$ARCH" = "ia64" ]
          then
             PLATFORM="ia64"
          fi

           PLAT="`file /stand/vmunix | awk '{ print $9 }'`"
           if [ "$PLAT" = "(LP64)" ]
           then
               PLATFORM="11_64"
           else
               PLAT1="`file /stand/vmunix | awk '{ print $2 }'`"
           if [ "$PLAT1" = "PA-RISC1.1" ]
           then
                PLATFORM="1020"
           else
                PLATFORM="11_32"
          fi
       fi
     fi
   fi

}


ValidateOS()
{

     # we dont support V4.n

    if [ "$OS" = "OSF1" ]
    then
       OSV="`uname -r | grep \"4.\"`"

       # if not null

       if test -n "$OSV"
       then
           echo " "
           echo "This media does not support TRU64 V4.n, $OSV"
           echo " "
           exit
       fi
    fi
     # we dont support 10.20
    if [ "$OS" = "HP-UX" ]
    then
       if [ "$OSREL" = "B.10.20" ]
       then
           echo " "
           echo "This media does not support HPUX 10.20"
           echo " "
           exit
       fi
    fi
     # we dont support  5.6
    if [ "$OS" = "SunOS" ]
    then
       if [ "$OSREL" = "5.6" ]
       then
           echo " "
           echo "This media does not support SunOS 5.6"
           echo " "
           exit
       fi
    fi
}

#-------------------------------------------------
# FUNCTIONS
#--------------------------------------------------

cleanup_install()
{
   $ECHO "exiting..."
}

ShowCommandLineOptions()
{
    $ECHO "PerfCap Install for UNIX Command line options"
    $ECHO ""
    $ECHO "    -silent"
    $ECHO "    -help"
    $ECHO " "
    $ECHO " Options"
    $ECHO "    -install_dir <path>"
    $ECHO "    -license_dir <path>"
    $ECHO "    -save_db"
    $ECHO "  "
    $ECHO " eCAP Monitor Options"
    $ECHO "    -dump n"
    $ECHO "    -poll n   or  -scan n"
    $ECHO "    -retain n"
    $ECHO "    -data_dir    <path>"
    $ECHO "    -mapdisk"
    $ECHO "    -ecap_verbose"
    $ECHO " "
    $ECHO "  PAWZ Agent Options"
    $ECHO "  "
    $ECHO "    -pawz_port n"
    $ECHO "    -pawz_verbose"
    $ECHO "    -pawz_server ipaddress"
    $ECHO "    -appdir  path  "
    $ECHO "  "
    $ECHO "  PAWZ Real-Time Agent Options"
    $ECHO "  "
    $ECHO "    -rta_port n"
    $ECHO "    -rta_scan n"
    $ECHO "    -rta_verbose"
    $ECHO "    -rta_process"
    $ECHO "  " 
    $ECHO "  Sample"
    $ECHO "     ./install.sh -silent -install_dir /data/perfcap -data_dir /data/ECP -license_dir /commondisk/perfcap_kit -scan 1000 -dump 120"
    $ECHO " "
}

ShowSelectedComponents()
{
    if [ $INSTALL_DC -eq 1 ]
    then
        $ECHO "  PerfCap.PerfCapMonitor"
    fi
    if [ $INSTALL_PAWZ -eq 1 ]
    then
        $ECHO "  PerfCap.PawzAgent"
    fi
    if [ $INSTALL_RT -eq 1 ]
    then
        $ECHO "  PerfCap.PawzRealtime"
    fi
    if [ $INSTALL_RN -eq 1 ]
    then
        $ECHO "  PerfCap.PerfCapRelNote"
    fi
    if [ $INSTALL_PLAN -eq 1 ]
    then
        $ECHO "  PerfCap.PerfCapPlanner"
    fi
    if [ $INSTALL_AN -eq 1 ]
    then
        $ECHO "  PerfCap.PerfCapAnalyze"
    fi
    if [ $INSTALL_PP -eq 1 ]
    then
        $ECHO "  PerfCap.PawzPlanner Support"
    fi
    if [ $INSTALL_DB -eq 1 ]
    then
         $ECHO "  PerfCap.PerfCapDb"
    fi
    $ECHO  " "
 }


UpdateInstallFlags()
{
     if [ $OPT_HAVE_INSTALLDIR = "0" ]
     then
        OPT_HAVE_INSTALLDIR="1"
        if test -h $DEFAULT_INSTALLDIR
        then 
            CWD="`pwd`"
            cd $DEFAULT_INSTALLDIR
            OPT_INSTALLDIR="`pwd -P`"
            cd $CWD
        else
            OPT_INSTALLDIR=$DEFAULT_INSTALLDIR
        fi  
     fi
}

GetCurrentSettings()
{
   ECAP_SETTINGS_FILE="$OPT_INSTALLDIR/settings/ecap_$HOSTNAME.config"
   PAWZ_SETTINGS_FILE="$OPT_INSTALLDIR/settings/pawz_$HOSTNAME.config"
   RTA_SETTINGS_FILE="$OPT_INSTALLDIR/settings/rta_$HOSTNAME.config"

    if [ -f  "$ECAP_SETTINGS_FILE" ]
    then
       CURRENT_SCAN=""
       CURRENT_DUMP=""
       CURRENT_PEAK=""
       CURRENT_MAPDISK=""
       CURRENT_RETAIN=""
       CURRENT_AUG_PROC=""
       CURRENT_AUG_NET=""
       CURRENT_ECAP_VERBOSE="" 

       CURRENT_SCAN="` cat $ECAP_SETTINGS_FILE | grep SCAN_RATE | awk -F"~" '{print $2 }'`"
       CURRENT_DUMP="` cat $ECAP_SETTINGS_FILE | grep WRITE_RATE | awk -F"~" '{print $2 }'`"
       CURRENT_PEAK="` cat $ECAP_SETTINGS_FILE | grep PEAK_RATE | awk -F"~" '{print $2 }'`"
       CURRENT_RETAIN="` cat $ECAP_SETTINGS_FILE | grep RETAIN | awk -F"~" '{print $2 }'`"
       CURRENT_MAPDISK="` cat $ECAP_SETTINGS_FILE | grep MAP_DISKNAMES | awk -F"~" '{print $2 }'`"
       CURRENT_AUG_PROC="` cat $ECAP_SETTINGS_FILE | grep AUGMENT_PROCESS | awk -F"~" '{print $2 }'`"
       CURRENT_AUG_NET="` cat $ECAP_SETTINGS_FILE | grep AUGMENT_NETWORK | awk -F"~" '{print $2 }'`"
      CURRENT_ECAP_VERBOSE="` cat $ECAP_SETTINGS_FILE | grep VERBOSE | awk -F"~" '{print $2 }'`"

      # if not specifed and we have found a value, use it
      if [ "$OPT_HAVE_DUMP" = "0" ] && [ "$CURRENT_DUMP" != "" ]
      then
         OPT_HAVE_DUMP="1"
         OPT_DUMP=$CURRENT_DUMP
      fi  
      if [ "$OPT_HAVE_ECAP_VERBOSE" = "0" ] && [ "$CURRENT_ECAP_VERBOSE" != "" ]
      then
         OPT_HAVE_ECAP_VERBOSE="1"
         OPT_ECAP_VERBOSE=$CURRENT_ECAP_VERBOSE
      fi  
      if [ "$OPT_HAVE_PEAK" = "0" ] && [ "$CURRENT_PEAK" != "" ]
      then
         OPT_HAVE_PEAK="1"
         OPT_PEAK=$CURRENT_PEAK
      fi  
      if [ "$OPT_HAVE_DC_SCAN" = "0" ] && [ "$CURRENT_SCAN" != "" ]
      then
         OPT_HAVE_DC_SCAN="1"
         OPT_DC_SCAN=$CURRENT_SCAN
      fi  
      if [ "$OPT_DC_RETAIN" = "0" ] && [ "$CURRENT_RETAIN" != "" ]
      then
         OPT_HAVE_DC_RETAIN="1"
         OPT_DC_RETAIN=$CURRENT_RETAIN
      fi  
      if [ "$OPT_DC_MAPDISK" = "0" ] && [ "$CURRENT_MAPDISK" != "" ]
      then
         OPT_DC_HAVE_MAPDISK="1"
         OPT_DC_MAPDISK=$CURRENT_MAPDISK
      fi  
      if [ "$OPT_AUG_PROC" = "" ] && [ "$CURRENT_AUG_PROC" != "" ]
      then
         OPT_HAVE_AUG_PROC="1"
         OPT_AUG_PROC=$CURRENT_AUG_PROC
      fi  
      if [ "$OPT_AUG_NET" = "" ] && [ "$CURRENT_AUG_NET" != "" ]
      then
         OPT_HAVE_AUG_NET="1"
         OPT_AUG_NET=$CURRENT_AUG_NET
      fi  
    fi

    if [ -f  "$PAWZ_SETTINGS_FILE" ]
    then
      CURRENT_PAWZ_PORT="" 
      CURRENT_PAWZ_VERBOSE="" 
      CURRENT_PAWZSERVER="" 
      CURRENT_PAWZ_APPDATADIR=""
      CURRENT_PAWZ_COMPRESSION=""

      CURRENT_PAWZ_PORT="` cat $PAWZ_SETTINGS_FILE | grep PAWZAGENT_PORT | awk -F"~" '{print $2 }'`"
      CURRENT_PAWZ_PAWZSERVER="` cat $PAWZ_SETTINGS_FILE | grep PAWZSERVER | awk -F"~" '{print $2 }'`"
      CURRENT_PAWZ_VERBOSE="` cat $PAWZ_SETTINGS_FILE | grep VERBOSE | awk -F"~" '{print $2 }'`"
      CURRENT_PAWZ_APPDATADIR="` cat $PAWZ_SETTINGS_FILE | grep APP_DATA_DIR | awk -F"~" '{print $2 }'`"
      CURRENT_PAWZ_COMPRESSION="` cat $PAWZ_SETTINGS_FILE | grep COMPRESSION_COMMAND | awk -F"~" '{print $2 }'`"

      # if not specifed and we have found a value, use ieE
      if [ "$OPT_HAVE_PAWZAGENT_PORT" = "0" ] && [ "$CURRENT_PAWZ_PORT" != "" ]
      then
         OPT_HAVE_PAWZAGENT_PORT="1"
         OPT_PAWZAGENT_PORT=$CURRENT_PAWZ_PORT
      fi  
      if [ "$OPT_HAVE_PAWZAGENT_VERBOSE" = "0" ] && [ "$CURRENT_PAWZ_VERBOSE" != "" ]
      then
         OPT_HAVE_PAWZAGENT_VERBOSE="1"
         OPT_PAWZAGENT_VERBOSE=$CURRENT_PAWZ_VERBOSE
      fi  
      if [ "$OPT_HAVE_PAWZAGENT_SERVER" = "0" ] && [ "$CURRENT_PAWZ_PAWZSERVER" != "" ]
      then
         OPT_HAVE_PAWZAGENT_SERVER="1"
         OPT_PAWZAGENT_SERVER=$CURRENT_PAWZ_PAWZSERVER
      fi  
      if [ "$OPT_HAVE_PAWZAGENT_APPDATADIR" = "0" ] && [ "$CURRENT_PAWZ_APPDATADIR" != "" ]
      then
         OPT_HAVE_PAWZAGENT_APPDATADIR="1"
         OPT_PAWZAGENT_APPDATADIR=$CURRENT_PAWZ_APPDATADIR
      fi  
      if [ "$OPT_HAVE_PAWZAGENT_COMPRESSION" = "0" ] && [ "$CURRENT_PAWZ_COMPRESSION" != "" ]
      then
         OPT_HAVE_PAWZAGENT_COMPRESSION="1"
         OPT_PAWZAGENT_COMPRESSION=$CURRENT_PAWZ_COMPRESSION
      fi  

    fi

    if [ -f  "$RTA_SETTINGS_FILE" ]
    then
      CURRENT_RTA_PORT="" 
      CURRENT_RTA_SCAN="" 
      CURRENT_RTA_PROCESS="" 
      CURRENT_RTA_VERBOSE="" 
      CURRENT_RTA_ALERTS="" 

      CURRENT_RTA_PORT="` cat $RTA_SETTINGS_FILE | grep RTA_PORT | awk -F"~" '{print $2 }'`"
      CURRENT_RTA_SCAN="` cat $RTA_SETTINGS_FILE | grep SCAN_RATE | awk -F"~" '{print $2 }'`"
      CURRENT_RTA_ALERTS="` cat $RTA_SETTINGS_FILE | grep ALERTS | awk -F"~" '{print $2 }'`"
      CURRENT_RTA_PROCESS="` cat $RTA_SETTINGS_FILE | grep PROCESSES | awk -F"~" '{print $2 }'`"
      CURRENT_RTA_VERBOSE="` cat $RTA_SETTINGS_FILE | grep VERBOSE | awk -F"~" '{print $2 }'`"

      if [ "$OPT_HAVE_PAWZRTA_PORT" = "0" ] && [ "$CURRENT_RTA_PORT" != "" ]
      then
         OPT_HAVE_PAWZRTA_PORT="1"
         OPT_RTA_PAWZPORT=$CURRENT_RTA_PORT
      fi  
      if [ "$OPT_HAVE_PAWZRTA_SCAN" = "0" ] && [ "$CURRENT_RTA_SCAN" != "" ]
      then
         OPT_HAVE_PAWZRTA_SCAN="1"
         OPT_PAWZRTA_SCAN=$CURRENT_RTA_SCAN
      fi  
      if [ "$OPT_HAVE_PAWZRTA_ALERT" = "" ] && [ "$CURRENT_RTA_ALERTS" != "" ]
      then
         OPT_HAVE_PAWZRTA_ALERT="1"
         OPT_PAWZRTA_ALERT=$CURRENT_RTA_ALERTS
      fi  
      if [ "$OPT_HAVE_PAWZRTA_PROC" = "0" ] && [ "$CURRENT_RTA_PROCESS" != "" ]
      then
         OPT_HAVE_PAWZRTA_PROC="1"
         OPT_PAWZRTA_PROC=$CURRENT_RTA_PROCESS
      fi  
      if [ "$OPT_HAVE_PAWZRTA_VERBOSE" = "0" ] && [ "$CURRENT_RTA_VERBOSE" != "" ]
      then
         OPT_HAVE_PAWZRTA_VERBOSE="1"
         OPT_PAWZRTA_VERBOSE=$CURRENT_RTA_VERBOSE
      fi  
    fi
    return 
}
ShowInstallationSelections()
{
     $ECHO " "
     $ECHO "Installing with the following components...."       
     ShowSelectedComponents


     $ECHO "Installing with the following settings...."       

     $ECHO " "
     $ECHO "   License Dir:                   $OPT_LICENSEDIR"
     $ECHO "   Install Dir:                   $OPT_INSTALLDIR"
     $ECHO " "
     if [ $INSTALL_DC -eq 1 ]
     then
         $ECHO " ECAP Monitor "
         $ECHO " "
         $ECHO "   Data Dir:                      $OPT_DATADIR"
         $ECHO "   eCAP Monitor Scan Rate:        $OPT_DC_SCAN"
         $ECHO "   eCAP Monitor Dump Rate:        $OPT_DUMP"
         $ECHO "   eCAP Monitor Peak Rate:        $OPT_PEAK"
         $ECHO "   eCAP Monitor Retain:           $OPT_DC_RETAIN"
         $ECHO "   eCAP Monitor Augment Process:  $OPT_AUG_PROC"
         $ECHO "   eCAP Monitor Augment Network:  $OPT_AUG_NET"
         $ECHO "   eCAP Monitor Verbose:          $OPT_ECAP_VERBOSE"
         $ECHO " "
     fi
     if [ $INSTALL_PAWZ -eq 1 ]
     then
         $ECHO " PAWZ Agent "
         $ECHO " "
         $ECHO "   PAWZ Agent Port:               $OPT_PAWZAGENT_PORT"
         $ECHO "   PAWZ Agent Verbose:            $OPT_PAWZAGENT_VERBOSE"
         $ECHO "   PAWZ Agent Server:             $OPT_PAWZAGENT_SERVER"
         $ECHO "   PAWZ Agent AppDataDir:         $OPT_PAWZAGENT_APPDATADIR"
         $ECHO "   PAWZ Agent Compression:         $OPT_PAWZAGENT_COMPRESSION"

     fi
     if [ $INSTALL_RT -eq 1 ]
     then
        $ECHO " PAWZ Real-Time Agent "
        $ECHO " "
        $ECHO "   PAWZ Real-Time Agent Port:     $OPT_PAWZRTA_PORT"
        $ECHO "   PAWZ Real-Time Agent Scan:     $OPT_PAWZRTA_SCAN"
        $ECHO "   PAWZ Real-Time Agent Alerts:   $OPT_PAWZRTA_ALERT"
        $ECHO "   PAWZ Real-Time Agent Process:  $OPT_PAWZRTA_PROC"
        $ECHO "   PAWZ Real-Time Agent Verbose:  $OPT_PAWZRTA_VERBOSE"
     fi

     $ECHO " "
     $ECHO " Licenses "
     $ECHO " "
     $ECHO "   eCAP Monitor:  $LICENSEFILE_ECAP_MONITOR"
     $ECHO "   eCAP Reducer:  $LICENSEFILE_ECAP_REDUCER"
     $ECHO "   eCAP Analyzer: $LICENSEFILE_ECAP_ANALYZER"
     $ECHO "   eCAP Planner:  $LICENSEFILE_ECAP_PLANNER"
     $ECHO " "
}

#
#-------------------------------------------------------------------
# GetCmdLine:  Process Command Line...
#-------------------------------------------------------------------

GetCmdLine()
{
#  $ECHO " Input Options =  [ $# ]"

   BAD_OPTS=""
   FOUND="0"

   while [ "$1" != "" ]
   do
      FOUND="0"
      if [ "$1" = "-silent" ]
      then
          OPT_SILENT="1"
          FOUND="1"
      fi
      if [ "$1" = "-help" ] || [ "$1" = "-?" ]
      then
          OPT_HELP="1"
          FOUND="1"
      fi

      if [ "$1" = "-install_dir" ] 
      then
          FOUND="1"
          OPT_HAVE_INSTALLDIR="1" 
          OPT_INSTALLDIR="$2"
          shift 1
      fi
      if [ "$1" = "-data_dir" ] 
      then
          FOUND="1"
          OPT_HAVE_DATADIR="1" 
          OPT_DATADIR="$2"
          shift 1
      fi
      if [ "$1" = "-license_dir" ] 
      then
          FOUND="1"
          OPT_HAVE_LICENSEDIR="1" 
          OPT_LICENSEDIR="$2"
          shift 1
      fi
      if [ "$1" = "-retain" ] 
      then
          FOUND="1"
          OPT_HAVE_DC_RETAIN="1" 
          OPT_DC_RETAIN="$2"
          shift 1
      fi
      if [ "$1" = "-mapdisk" ] 
      then
          FOUND="1"
          OPT_HAVE_DC_MAPDISK="1" 
          OPT_DC_MAPDISK="1"
      fi

      #  ecap

      if [ "$1" = "-poll" ]  || [ "$1" = "-scan" ]
      then
          FOUND="1"
          OPT_HAVE_DC_SCAN="1" 
          OPT_DC_SCAN="$2"
          shift 1
      fi
      if [ "$1" = "-dump" ] 
      then
          FOUND="1"
          OPT_HAVE_DUMP="1" 
          OPT_DUMP="$2"
          shift 1
      fi
      if [ "$1" = "-peak" ] 
      then
          FOUND="1"
          OPT_HAVE_PEAK="1" 
          OPT_PEAK="$2"
          shift 1
      fi
      if [ "$1" = "-augment_process" ] 
      then
          FOUND="1"
          OPT_HAVE_AUG_PROC="1" 
          OPT_AUG_PROC="1"
      fi
      if [ "$1" = "-augment_network" ] 
      then
          FOUND="1"
          OPT_HAVE_AUG_NET="1" 
          OPT_AUG_NET="1"
      fi
      if [ "$1" = "-ecap_verbose" ] 
      then
          FOUND="1"
          OPT_HAVE_ECAP_VERBOSE="1" 
          OPT_ECAP_VERBOSE="1"
      fi

      # pawz agent 

      if [ "$1" = "-pawz_port" ] 
      then
          FOUND="1"
          OPT_HAVE_PAWZAGENT_PORT="1" 
          OPT_PAWZAGENT_PORT="$2"
          shift 1
      fi
      if [ "$1" = "-pawz_verbose" ] 
      then
          FOUND="1"
          OPT_HAVE_PAWZAGENT_VERBOSE="1" 
          OPT_PAWZAGENT_VERBOSE="1"
      fi
      if [ "$1" = "-pawz_server" ] 
      then
          OPT_HAVE_PAWZAGENT_SERVER="1" 
          FOUND="1"
          OPT_PAWZAGENT_SERVER="$2"
          shift 1
      fi
      if [ "$1" = "-pawz_appdata_dir" ] 
      then
          OPT_HAVE_PAWZAGENT_APPDATADIR="1" 
          FOUND="1"
          OPT_PAWZAGENT_APPDATADIR="$2"
          shift 1
      fi
      if [ "$1" = "-pawz_compression" ] 
      then
          OPT_HAVE_PAWZAGENT_COMPRESSION="1" 
          FOUND="1"
          OPT_PAWZAGENT_COMPRESSION="$2"
          shift 1
      fi


      # pawzrta 

      if [ "$1" = "-rta_port" ] 
      then
          FOUND="1"
          OPT_HAVE_PAWZRTA_PORT="1" 
          OPT_PAWZRTA_PORT="$2"
          shift 1
      fi
      if [ "$1" = "-rta_scan" ] 
      then
          FOUND="1"
          OPT_HAVE_PAWZRTA_SCAN="1" 
          OPT_PAWZRTA_SCAN="$2"
          shift 1
      fi
      if [ "$1" = "-rta_verbose" ] 
      then
          FOUND="1"
          OPT_HAVE_PAWZRTA_VERBOSE="1" 
          OPT_PAWZRTA_VERBOSE="1"
      fi
      if [ "$1" = "-rta_process" ] 
      then
          FOUND="1"
          OPT_HAVE_PAWZRTA_PROC="1" 
          OPT_PAWZRTA_PROC="1"
      fi
      if [ "$1" = "-plan" ] 
      then
          FOUND="1"
          INSTALL_PLAN=1 
          INSTALL_PP=1 
      fi
      if [ "$1" = "-save_db" ] 
      then
          FOUND="1"
           OPT_SAVE_DB="1"
      fi
      if [ "$FOUND" = "0" ]
      then
         BAD_OPTS="$BAD_OPTS $1"
      fi

      shift 1
   done

   if [ "$BAD_OPTS" != "" ] 
   then
        BadOptions
   fi
   return
}

BadOptions()
{
   $ECHO "Error: The following are unknown command line options"
   $ECHO " "
   $ECHO " $BAD_OPTS"
   $ECHO " "
   $ECHO " use -help for a list of supported options"
   $ECHO " "
   exit 0
}


ValidateCmdLine()
{
  VALID_INSTALL_DIR=1
  if [ "$HAVE_OPT_INSTALLDIR" = "1" ]
  then
    if [ "$OPT_INSTALLDIR" = "/usr/bin" ] || [ "$OPT_INSTALLDIR" = "/usr" ] 
    then
       VALID_INSTALL_DIR=0
    fi
    if [ "$OPT_INSTALLDIR" = "/" ] || [ "$OPT_INSTALLDIR" = "/var" ] 
    then
       VALID_INSTALL_DIR=0
    fi
  fi

  if [ $VALID_INSTALL_DIR -eq 0 ]
  then
    $ECHO "Selected -install_dir is not valid for this install, $OPT_INSTALLDIR"
    exit 1
  fi
  return
}

DefaultComponents()
{
    INSTALL_PLAN=0
    INSTALL_DC=1
    INSTALL_AN=1
    INSTALL_PAWZ=1
    INSTALL_RT=1
    INSTALL_RN=1
    INSTALL_DB=1
}

#-------------------------------------------------
# FUNCTIONS : SelectComponents
#--------------------------------------------------

SelectComponents()
{
  DONE_SEL=0
  if [ $OS = "Linux"  ]
  then
     return
  fi


  while [ $DONE_SEL -eq 0 ]
  do

    if [ $USE_ECHO_N -eq 1 ]
    then
       $ECHON "Do you wish to install  PAWZ Agent?    (y/n) [y]: "
    else
       $ECHO "Do you wish to install  PAWZ Agent?    (y/n) [y]: \c"
    fi
    read answer
    if [ "$answer" = 'Y' ] || [ "$answer" = 'y' ] || \
     [ "$answer" = "yes" ]  || [ "$answer" = "YES" ] || [ "$answer" = "" ]
    then
        INSTALL_PAWZ=1
        INSTALL_DB=1
    else
        INSTALL_PAWZ=0
    fi

    if [ $USE_ECHO_N -eq 1 ]
    then
       $ECHON "Do you wish to install  PAWZ Realtime? (y/n) [y]: "
    else
       $ECHO "Do you wish to install  PAWZ Realtime? (y/n) [y]: \c"
    fi
    read answer
    if [ "$answer" = 'Y' ] || [ "$answer" = 'y' ] || \
       [ "$answer" = "yes" ]  || [ "$answer" = "YES" ] || [ "$answer" = "" ]
    then
         INSTALL_RT=1
    else
         INSTALL_RT=0
     fi

    if [ $USE_ECHO_N -eq 1 ]
    then
       $ECHON "Do you wish to install  eCAP Monitor?  (y/n) [y]: "
    else
       $ECHO "Do you wish to install  eCAP Monitor?  (y/n) [y]: \c"
    fi

    read answer
    if [ "$answer" = 'Y' ] || [ "$answer" = 'y' ] || \
       [ "$answer" = "yes" ]  || [ "$answer" = "YES" ] || [ "$answer" = "" ]
    then
        INSTALL_DC=1
    else
        INSTALL_DC=0
    fi

    if [ $USE_ECHO_N -eq 1 ]
    then
       $ECHON "Do you wish to install  Release Notes? (y/n) [y]: "
    else
       $ECHO "Do you wish to install  Release Notes? (y/n) [y]: \c"
    fi
    read answer
    if [ "$answer" = 'Y' ] || [ "$answer" = 'y' ] || \
       [ "$answer" = "yes" ]  || [ "$answer" = "YES" ] || [ "$answer" = "" ]
    then
        INSTALL_RN=1
    else 
        INSTALL_RN=0
    fi

    if [ $USE_ECHO_N -eq 1 ]
    then
       $ECHON "Do you wish to install  eCAP Analyzer/Reducer/PAWZ Planner Support? (y/n) [y]: "
    else
       $ECHO "Do you wish to install  eCAP Analyzer/Reducer/PAWZ Planner Support? (y/n) [y]: \c"
    fi
    read answer
    if [ "$answer" = 'Y' ] || [ "$answer" = 'y' ] || \
       [ "$answer" = "yes" ]  || [ "$answer" = "YES" ] || [ "$answer" = "" ]
    then
         INSTALL_DB=1
         INSTALL_AN=1
    else
         INSTALL_AN=0
    fi
   if [ $SUPPORTED_OS_FOR_PLANNER -eq 1 ] 
   then
        if [ $USE_ECHO_N -eq 1 ]
        then
           $ECHON "Do you wish to install  eCAP Capacity Planner? (y/n) [n]: "
        else
          $ECHO "Do you wish to install  eCAP Capacity Planner? (y/n) [n]: \c"
        fi

        read answer
        if [ "$answer" = 'Y' ] || [ "$answer" = 'y' ] || \
           [ "$answer" = "yes" ]  || [ "$answer" = "YES" ]
        then
         INSTALL_DB=1
         INSTALL_PLAN=1
        else
         INSTALL_PLAN=0
        fi

    fi


    if [ $INSTALL_PLAN -eq 1  ] && [ $INSTALL_AN -eq 1  ] && \
       [ $INSTALL_RN -eq 1  ] && [ $INSTALL_RT -eq 1  ] && \
       [ $INSTALL_DB -eq 1  ] && [ $INSTALL_PAWZ -eq 1  ] && [ $INSTALL_DC -eq 1  ]
    then
        INSTALL_ALL=1
    fi

    $ECHO " "
    $ECHO "The following will be installed "
    $ECHO " "
    ShowSelectedComponents

    if [ $USE_ECHO_N -eq 1 ]
    then
       $ECHON "Proceed with installation ? (y/n/q) [n]: "
    else
       $ECHO "Proceed with installation ? (y/n/q) [n]: \c"
    fi
    read answer

    if [ "$answer" = 'Q' ] || [ "$answer" = 'q' ] || \
       [ "$answer" = "quit" ]  || [ "$answer" = "QUIT" ]
    then
        cleanup_install
        exit
    fi
  if [ "$answer" = 'Y' ] || [ "$answer" = 'y' ] || \
     [ "$answer" = "yes" ]  || [ "$answer" = "YES" ]
  then
      DONE_SEL=1
  else
    INSTALL_PLAN=0
     INSTALL_AN=0
     INSTALL_PP=0
     INSTALL_RN=0
     INSTALL_RT=0
     INSTALL_DB=0
     INSTALL_PAWZ=0
     INSTALL_DC=0
  fi
  done
}


#----------------------------------------------------------
#  GetLicenseFile:   find the license files
#    search order  
#         -license_dir
#         current_dir
#-----------------------------------------------------------

GetLicenseFile()
{
   # specified.

   if [ "$OPT_HAVE_LICENSEDIR" = "1" ]
   then 
      if [ -f "$OPT_LICENSEDIR/ecap-monitor.txt" ]
      then
         LICENSEFILE_ECAP_MONITOR="$OPT_LICENSEDIR/ecap-monitor.txt"
      fi
      if [ -f "$OPT_LICENSEDIR/ecap-reducer.txt" ]
      then
         LICENSEFILE_ECAP_REDUCER="$OPT_LICENSEDIR/ecap-reducer.txt"
      fi
      if [ -f "$OPT_LICENSEDIR/ecap-analyzer.txt" ]
      then
         LICENSEFILE_ECAP_ANALYZER="$OPT_LICENSEDIR/ecap-analyzer.txt"
      fi
      if [ -f "$OPT_LICENSEDIR/ecap-planner.txt" ]
      then
         LICENSEFILE_ECAP_PLANNER="$OPT_LICENSEDIR/ecap-planner.txt"
      fi
   fi

   if [ "$LICENSEFILE_ECAP_MONITOR" = "" ]
   then
      if [ -f "$KIT_MEDIA_ROOT/ecap-monitor.txt" ]
      then	
         LICENSEFILE_ECAP_MONITOR="$KIT_MEDIA_ROOT/ecap-monitor.txt"
      fi
   fi
   if [ "$LICENSEFILE_ECAP_ANALYZER" = "" ] 
   then
      if [ -f "$KIT_MEDIA_ROOT/ecap-analyzer.txt" ]
      then
         LICENSEFILE_ECAP_ANALYZER="$KIT_MEDIA_ROOT/ecap-analyzer.txt"
      fi
   fi
   if [ "$LICENSEFILE_ECAP_REDUCER" = "" ] 
   then
      if [ -f "$KIT_MEDIA_ROOT/ecap-reducer.txt" ]
      then
         LICENSEFILE_ECAP_REDUCER="$KIT_MEDIA_ROOT/ecap-reducer.txt"
      fi
   fi
   if [ "$LICENSEFILE_ECAP_PLANNER" = "" ] 
   then
      if [ -f "$KIT_MEDIA_ROOT/ecap-planner.txt" ]
      then
         LICENSEFILE_ECAP_PLANNER="$KIT_MEDIA_ROOT/ecap-planner.txt"
      fi
   fi

   if [ "$LICENSEFILE_ECAP_MONITOR" = "" ]
   then
      if [ -f "$OPT_INSTALLDIR/ecap-monitor.txt" ]
      then	
         LICENSEFILE_ECAP_MONITOR="$OPT_INSTALLDIR/ecap-monitor.txt"
      fi
   fi
   if [ "$LICENSEFILE_ECAP_ANALYZER" = "" ] 
   then
      if [ -f "$OPT_INSTALLDIR/ecap-analyzer.txt" ]
      then
         LICENSEFILE_ECAP_ANALYZER="$OPT_INSTALLDIR/ecap-analyzer.txt"
      fi
   fi
   if [ "$LICENSEFILE_ECAP_REDUCER" = "" ] 
   then
      if [ -f "$OPT_INSTALLDIR/ecap-reducer.txt" ]
      then
         LICENSEFILE_ECAP_REDUCER="$OPT_INSTALLDIR/ecap-reducer.txt"
      fi
   fi
   if [ "$LICENSEFILE_ECAP_PLANNER" = "" ] 
   then
      if [ -f "$OPT_INSTALLDIR/ecap-planner.txt" ]
      then
         LICENSEFILE_ECAP_PLANNER="$OPT_INSTALLDIR/ecap-planner.txt"
      fi
   fi
   return
}

#------------------------------------------------------
# Cleanup Links to Directories, Make Directories and copy
# license files.
#------------------------------------------------------

PreInstall()
{
    # remove softlink 

    if test -h $DEFAULT_INSTALLDIR
    then
             $ECHO "have default as link - need to remove"
             rm $DEFAULT_INSTALLDIR
    fi          

    if [ ! -d $OPT_INSTALLDIR ]
    then
         mkdir $OPT_INSTALLDIR
    fi
    if [ ! -d  "$DEFAULT_INSTALLDIR" ]
    then
          ln -s $OPT_INSTALLDIR  $DEFAULT_INSTALLDIR
    fi

  # Copy licenses

     if [ "$LICENSEFILE_ECAP_MONITOR" != "" ] 
     then 
       if [ "$LICENSEFILE_ECAP_MONITOR" != "$OPT_INSTALLDIR/ecap-monitor.txt" ]
       then
           cp -f "$LICENSEFILE_ECAP_MONITOR" $OPT_INSTALLDIR
           chmod 0744 $OPT_INSTALLDIR/ecap-monitor.txt
       fi
     fi

     if [ "$LICENSEFILE_ECAP_ANALYZER" != "" ] 
     then 
       if [ "$LICENSEFILE_ECAP_ANALYZER" != "$OPT_INSTALLDIR/ecap-analyzer.txt" ]
       then
            cp -f $LICENSEFILE_ECAP_ANALYZER $OPT_INSTALLDIR
           chmod 0744 $OPT_INSTALLDIR/ecap-analyzer.txt
       fi
     fi

     if [ "$LICENSEFILE_ECAP_REDUCER" != "" ] 
     then 
       if [ "$LICENSEFILE_ECAP_REDUCER" != "$OPT_INSTALLDIR/ecap-reducer.txt" ]
       then
            cp -f $LICENSEFILE_ECAP_REDUCER $OPT_INSTALLDIR
            chmod 0744 $OPT_INSTALLDIR/ecap-reducer.txt
       fi
     fi

     if [ "$LICENSEFILE_ECAP_PLANNER" != "" ] 
     then 
       if [ "$LICENSEFILE_ECAP_PLANNER" != "$OPT_INSTALLDIR/ecap-planner.txt" ]
       then
           cp -f $LICENSEFILE_ECAP_PLANNER $OPT_INSTALLDIR
            chmod 0744 $OPT_INSTALLDIR/ecap-planner.txt
       fi
     fi

    #  remove softlink for data, if one was specified

    if [ $OPT_HAVE_DATADIR != "" ] 
    then
       if test -h "$DEFAULT_INSTALLDIR/data"
        then
            rm "$DEFAULT_INSTALLDIR/data"
        fi
    fi 

    #  mkdir a specified data path , if didnt create it mark as null

    if [ "$OPT_DATADIR" != "" ]
    then
         if [ ! -d "$OPT_DATADIR" ]
         then
             mkdir $OPT_DATADIR
             if [ ! -d "$OPT_DATADIR"  ] 
             then
                OPT_DATADIR=""
             fi
         fi
    fi


    # if we dont have a data path , then if specified, it points to 
    # some other location, so create a softlink

    if [ ! -d "$DEFAULT_INSTALLDIR/data" ]
    then

        if [ "$OPT_DATADIR" != "" ]
        then
          if [ -d "$OPT_DATADIR" ]
          then
             if [ "$DEFAULT_INSTALLDIR/data" != "$OPT_DATADIR" ]
             then
                ln -s "$OPT_DATADIR"  "$DEFAULT_INSTALLDIR/data"
             fi
          fi
        fi
    fi

    # if we still dont have link or data then create data  
    # 

    if [ ! -d  "$DEFAULT_INSTALLDIR/data" ]
    then
       mkdir $DEFAULT_INSTALLDIR/data
    fi
}

#--------------------------------------------------
# Save DBA FILES (need to add /usr/local)
#--------------------------------------------------

UninstallSaveDB()
{
  if [ -d $DEFAULT_INSTALLDIR/db ]
  then
     if [ -f $DEFAULT_INSTALLDIR/db/perfcap_scsi.dba ]
     then
        $ECHO "Copying *.dba to  $DEFAULT_INSTALLDIR/db.`date +"%d%h%Y_%H%M"`"
        mkdir $DEFAULT_INSTALLDIR/db."`date +"%d%h%Y_%H%M"`"
        cp $DEFAULT_INSTALLDIR/db/*.dba   $DEFAULT_INSTALLDIR/db."`date +"%m%h%Y_%H%M"`"
        $ECHO " "
     fi
  fi
  return
}

#
# GetInstallPath: if silent & not a re-install
#

GetInstallPath()
{

    $ECHO "Get InstallPath...$EXISTING_INSTALLDIR"
    if [ "$OPT_SILENT" = "0" ]
    then
       if [ "$EXISTING_INSTALLDIR"  = "" ]
       then
          if [ $USE_ECHO_N -eq 1 ]
          then
             $ECHON "Enter install path [ $DEFAULT_INSTALLDIR ]: "
           else
              $ECHO "Enter install path [ $DEFAULT_INSTALLDIR ]: \c"
          fi
          read answer
          if [ "$answer" != "" ] 
          then
             OPT_INSTALLDIR=$answer
          fi 
          if [ $USE_ECHO_N -eq 1 ]
          then
              $ECHON "Enter data path    [ $OPT_INSTALLDIR/data ]: "
           else
              $ECHO "Enter data path    [ $OPT_INSTALLDIR/data ]: \c"
          fi
          read answer
          if [ "$answer" != "" ] 
          then
             OPT_DATADIR=$answer
          else 
             OPT_DATADIR="$OPT_INSTALLDIR/data"
          fi 



       fi
    fi
   return
}

GetLicensePath()
{
    if [ "$OPT_SILENT" = "0" ]
    then
        if [ $USE_ECHO_N -eq 1 ]
        then
             $ECHON "Enter path for licenses   [ $OPT_LICENSEDIR  ]: "
        else
            $ECHO "Enter path for licenses   [ $OPT_LICENSEDIR ]: \c"
       fi
       read answer
       if [ "$answer" != "" ] 
       then
         OPT_LICENSEDIR="$answer"
         OPT_HAVE_LICENSEDIR="1"
       fi 
       GetLicenseFile
    fi
    return 
}

GetExistingSettings()
{
  CWD="`pwd`"
  if [ -h $DEFAULT_INSTALLDIR ]
  then

        $ECHO " check installdir $DEFAULT_INSTALLDIR"
        cd $DEFAULT_INSTALLDIR
        EXISTING_INSTALLDIR="`pwd -P`"
  fi 
  if [ -h "$DEFAULT_INSTALLDIR/data" ]
    then
        $ECHO "check $DEFAULT_INSTALLDIR/data"
        cd $DEFAULT_INSTALLDIR/data
        EXISTING_DATADIR="`pwd -P`"
    fi 
    cd $CWD

   # if we havent specified a new install folder (using default)
   # and existing is a link,   set install folder to that dir

   if [ "$OPT_HAVE_INSTALLDIR" = "0" ]
   then
        if [ "$EXISTING_INSTALLDIR" != "" ]
        then
           OPT_INSTALLDIR=$EXISTING_INSTALLDIR
        fi
   fi
   if [ "$OPT_HAVE_DATADIR" = "0" ]
   then
        if [ "$EXISTING_DATADIR" != "" ]
        then
           OPT_DATADIR=$EXISTING_DATADIR
        fi
   fi

  # if we get here, check for existing directory
  # so ask path will know if we have an install   
  if [ "$EXISTING_INSTALLDIR" = "" ]
  then
      if [ -d "$DEFAULT_INSTALLDIR" ]
      then
         EXISTING_INSTALLDIR=$DEFAULT_INSTALLDIR
      fi
  fi
  return
}
#---------------------------------------------------
# uninstall existing, we know the default must exist
# as a soft link or directory
#---------------------------------------------------

UninstallExisting()
{
 
   HAVE_UNINSTALL=0

   UNDIR=$DEFAULT_INSTALLDIR

   if [ -f $UNDIR/uninstall.sh ]
   then
      HAVE_UNINSTALL=1
      $ECHO " PerfCap software is already installed, deinstalling..."
      $ECHO " "

      if [ $OPT_SAVE_DB = "1" ]
      then
         UninstallSaveDB
      fi

      INSTALL_IS_REINSTALL=1

      sh $UNDIR/uninstall.sh -silent

      $ECHO " "
      $ECHO "Finished deinstall,   Installation proceeding..."
      $ECHO "*****************************************************************"
      return 
   fi 
   return
}

#----------------------------------------------
# OS SPECIFIC INSTALL RTNS
#-----------------------------------------------

InstallAIX()
{
    if [ $INSTALL_RN -eq 1 ]
    then
        /usr/lib/instl/sm_inst installp_cmd -a -Q -d '.' \
     -f '9.2.0.0 eCAP Release Notes  @@PerfCap.PerfCapRelnotes 9.2.0.0 ' \
                 '-c' '-N' '-g' '-X' '-G'
        rm -f .toc
    fi

    if [ $INSTALL_DB -eq 1 ]
    then
        /usr/lib/instl/sm_inst installp_cmd -a -Q -d '.' \
     -f '+9.2.0.0 PerfCap Device Db  @@PerfCap.PerfCapDb 9.2.0.0 ' \
                 '-c' '-N' '-g' '-X' '-G'
        rm -f .toc
    fi

    if [ $INSTALL_AN -eq 1 ]
    then
        /usr/lib/instl/sm_inst installp_cmd -a -Q -d '.' \
  -f '+9.2.0.0 eCAP Analyzer and Reducer @@PerfCap.PerfCapAnalyze 9.2.0.0 ' \
                 '-c' '-N' '-g' '-X' '-G'
        rm -f .toc
    fi
    if [ $INSTALL_PLAN -eq 1 ]
    then
        /usr/lib/instl/sm_inst installp_cmd -a -Q -d '.' \
     -f '+9.2.0.0 eCAP Planner  @@PerfCap.PerfCapPlan 9.2.0.0 ' \
                 '-c' '-N' '-g' '-X' '-G'
        rm -f .toc
    fi
    if [ $INSTALL_DC -eq 1 ]
    then
        /usr/lib/instl/sm_inst installp_cmd -a -Q -d '.' \
     -f '+9.2.0.0 eCAP Monitor  @@PerfCap.PerfCapMonitor 9.2.0.0 ' \
                 '-c' '-N' '-g' '-X' '-G'
        rm -f .toc
    fi
    if [ $INSTALL_PAWZ -eq 1 ]
    then
        /usr/lib/instl/sm_inst installp_cmd -a -Q -d '.' \
     -f '+9.2.0.0 PAWZ Agent  @@PerfCap.PawzAgent 9.2.0.0 ' \
                 '-c' '-N' '-g' '-X' '-G'
        rm -f .toc
    fi
    if [ $INSTALL_RT -eq 1 ]
    then
        /usr/lib/instl/sm_inst installp_cmd -a -Q -d '.' \
     -f '9.2.0.0 PAWZ Realtime  @@PerfCap.PawzRealtime 9.2.0.0 ' \
                 '-c' '-N' '-g' '-X' '-G'
        rm -f .toc
    fi
}

#----------------------------------------------------

InstallSUN()
{

   if [ "$OSREL" = "5.6" ]
   then
      INSTALL_PLAN=0
        $ECHO "eCAP products have been discontinued on Solaris 5.6, please use eCAP V8.1"
        $ECHO "or contact PerfCap for additionalinformation"
        exit        
   fi

    if [ ! -f `pwd`/perfcap_response ]
    then
        $ECHO "perfcap_response not found! , file required!"
        exit        
    fi
    if [ -f `pwd`/perfcap_admin ]
    then
       if [ $INSTALL_DB -eq 1 ]
       then
           $ECHO "Installing PerfCap DB"
           pkgadd -n -a `pwd`/perfcap_admin -r ./perfcap_response -d ./PerfCap PerfCapDB
       fi

       if [ $INSTALL_DC -eq 1 ]
       then
          $ECHO "Installing PerfCap DC"
          pkgadd -n -a `pwd`/perfcap_admin -r ./perfcap_response -d  ./PerfCap PerfCapDC
       fi
       if [ $INSTALL_PAWZ -eq 1 ]
       then
           $ECHO "Installing PerfCap PZ"
          pkgadd -n -a `pwd`/perfcap_admin -r ./perfcap_response -d ./PerfCap PerfCapPZ
       fi
       if [ $INSTALL_RT -eq 1 ]
       then
           $ECHO "Installing PerfCap RT"
           pkgadd -n -a `pwd`/perfcap_admin -r ./perfcap_response -d ./PerfCap PerfCapRT
       fi

       if [ $INSTALL_AN -eq 1 ]
       then
          $ECHO "Installing PerfCap AN"
           pkgadd -n -a `pwd`/perfcap_admin -r ./perfcap_response -d ./PerfCap PerfCapAN
       fi

       if [ $INSTALL_RN -eq 1 ] 
       then
          $ECHO "Installing PerfCap RN"
          pkgadd -n -a `pwd`/perfcap_admin -r ./perfcap_response -d ./PerfCap PerfCapRN
       fi
       if [ $INSTALL_PLAN -eq 1 ] 
       then
          $ECHO "Installing PerfCapPL"
          pkgadd -n -a `pwd`/perfcap_admin -r ./perfcap_response -d ./PerfCap PerfCapPL
       fi

       cp `pwd`/perfcap_admin $DEFAULT_INSTALLDIR/settings

    else
      $ECHO "perfcap_admin installation file NOT Found!"
      pkgadd -d ./PerfCap -r ./perfcap_response
    fi

}

#----------------------------------------------------

InstallOSF()
{
    if [ $INSTALL_RN -eq 1 ]
    then
       /usr/sbin/setld -l ./kit PERFCAPRELNOTE910
    fi

    if [ $INSTALL_DB -eq 1 ]
    then
       /usr/sbin/setld -l ./kit PERFCAPBASE910
    fi
    if [ $INSTALL_AN -eq 1 ]
    then
       /usr/sbin/setld -l ./kit PERFCAPANALYZE910
    fi
    if [ $INSTALL_PLAN -eq 1 ]
    then
       /usr/sbin/setld -l ./kit PERFCAPPLAN910
    fi
    if [ $INSTALL_DC -eq 1 ]
    then
       /usr/sbin/setld -l ./kit PERFCAPMONITOR910
    fi
    if [ $INSTALL_PAWZ -eq 1 ]
    then
       /usr/sbin/setld -l ./kit PERFCAPPAWZ910
    fi
    if [ $INSTALL_RT -eq 1 ]
    then
       /usr/sbin/setld -l ./kit PERFCAPREALTIME910
    fi
}

#----------------------------------------------------

InstallESX()
{
   echo "Install PerfCap	ESX"
   rpm --install  $KIT_OS_MEDIA_ROOT/$RPMKIT
}

InstallLinuxIA64()
{
   echo "Install PerfCap Linux IA64"
   rpm --install  $KIT_OS_MEDIA_ROOT/$RPMKIT
   return
}

InstallLinux()
{
   ARCH="`uname -m`"
   INSTALL_ROOT=`pwd`

   $ECHO  "    Installing Perfcap Linux...."
   rpm --install  $KIT_OS_MEDIA_ROOT/$RPMKIT


}

#-----------------------------------------------------------------

InstallHPUX()
{
    HP_INSTALL_OPTS=""
    ARCH=`uname -m`
    if [ "$ARCH" = "ia64" ]
    then
       HP_INSTALL_OPTS="-x mount_all_filesystems=false"
    fi

    if [ $INSTALL_ALL -eq 1 ]
    then
       swinstall $HP_INSTALL_OPTS -s "`hostname`":"`pwd`"/PerfCap PerfCap
    else
        if [ $INSTALL_DB -eq 1 ]
        then
              $ECHO "Installing PerfCapDb.DbFiles..."
              swinstall $HP_INSTALL_OPTS -s "`hostname`":"`pwd`"/PerfCap PerfCapDb.DbFiles
        fi
        if [ $INSTALL_DC -eq 1 ]
        then
              $ECHO "Installing PerfMonitor.MonFiles..."
              swinstall $HP_INSTALL_OPTS -s "`hostname`":"`pwd`"/PerfCap PerfCapMonitor.MonFiles
        fi
        if [ $INSTALL_RN -eq 1 ]
        then
            $ECHO  "Installing Release Notes.."
            swinstall $HP_INSTALL_OPTS -s "`hostname`":"`pwd`"/PerfCap PerfCapRelNotes.RelNotesFiles
        fi
        if [ $INSTALL_PAWZ -eq 1 ]
        then
           $ECHO  "Installing PAWZ Agent..."
           swinstall $HP_INSTALL_OPTS -s "`hostname`":"`pwd`"/PerfCap PawzAgent.AgentFiles
        fi
        if [ $INSTALL_RT -eq 1 ]
        then
           $ECHO  "Installing PAWZ Real-Time..."
           swinstall $HP_INSTALL_OPTS -s "`hostname`":"`pwd`"/PerfCap PawzRealtime.RealtimeFiles
        fi
        if [ $INSTALL_PLAN -eq 1 ]
        then
           $ECHO "Installing Capacity Planner..."
           swinstall $HP_INSTALL_OPTS -s "`hostname`":"`pwd`"/PerfCap PerfCapPlan.PlanFiles
        fi
        if [ $INSTALL_AN -eq 1 ]
        then
           $ECHO "Installing Analyzer..."
           swinstall $HP_INSTALL_OPTS  -s "`hostname`":"`pwd`"/PerfCap PerfCapAnalyze.AnalyzeFiles
        fi
   fi

}

#-----------------------------------------------------------------

InstallSoftware()
{
    cd $KIT_OS_MEDIA_ROOT
    if [ "$OS" = "AIX" ]
    then
        InstallAIX
    fi
    if [ "$OS" = "SunOS" ]
    then
        InstallSUN
    fi
    if [ "$OS" = "OSF1" ]
    then
        InstallOSF
    fi
    if [ "$OS" = "HP-UX" ]
    then
        InstallHPUX
    fi
    if [ "$OS" = "Linux" ]
    then
        if [ -d /proc/vmware ]
        then
           InstallESX
        else 
           ARCH=`uname -m`
           if [ "$ARCH" = "ia64" ]
           then
              InstallLinuxIA64
           else
              InstallLinux
           fi
        fi
    fi
    return
}

#-----------------------------------------------------------------

CreateCmdLine()
{

   if [ "$OPT_HAVE_DUMP" != "" ]
   then
       ECAP_MONITOR_OPT="$ECAP_MONITOR_OPT -dump $OPT_DUMP"
   fi
   if [ "$OPT_HAVE_PEAK" != "" ]
   then
       ECAP_MONITOR_OPT="$ECAP_MONITOR_OPT  -peak $OPT_PEAK"
   fi
   if [ "$OPT_HAVE_DC_SCAN" != "" ]
   then
       ECAP_MONITOR_OPT="$ECAP_MONITOR_OPT  -poll $OPT_DC_SCAN"
   fi
   if [ "$OPT_HAVE_DC_RETAIN" != "" ]
   then
       ECAP_MONITOR_OPT="$ECAP_MONITOR_OPT -retain $OPT_DC_RETAIN"
   fi
   if [ "$OPT_AUG_NET" = "1" ]
   then
       ECAP_MONITOR_OPT="$ECAP_MONITOR_OPT -augment_network"
   fi
   if [ "$OPT_AUG_PROC" = "1" ]
   then
       ECAP_MONITOR_OPT="$ECAP_MONITOR_OPT  -augment_process"
   fi
   if [ "$OPT_ECAP_VERBOSE"  = "1" ]
   then 
       ECAP_MONITOR_OPT="$ECAP_MONITOR_OPT  -verbose"
   fi
   if [ "$OPT_DC_MAPDISK" = "1" ] && [ "$OS" = "SunOS" ] 
   then
       ECAP_MONITOR_OPT="$ECAP_MONITOR_OPT  -mapdisk"
   fi
   if [ "$OPT_HAVE_PAWZAGENT_PORT"  != "" ]
   then 
       PAWZ_AGENT_OPT="$PAWZ_AGENT_OPT -port $OPT_PAWZAGENT_PORT"
   fi
   if [ "$OPT_PAWZAGENT_VERBOSE"  = "1" ]
   then 
       PAWZ_AGENT_OPT="$PAWZ_AGENT_OPT -verbose" 
   fi
   if [ "$OPT_HAVE_PAWZAGENT_SERVER" != "" ]
   then 
       PAWZ_AGENT_OPT="$PAWZ_AGENT_OPT -server $OPT_PAWZAGENT_SERVER"
   fi
   if [ "$OPT_PAWZAGENT_APPDATADIR" != "" ]
   then 
       PAWZ_AGENT_OPT="$PAWZ_AGENT_OPT -appdir $OPT_PAWZAGENT_APPDATADIR"
   fi
   if [ "$OPT_PAWZAGENT_COMPRESSION" != "" ]
   then 
       PAWZ_AGENT_OPT="$PAWZ_AGENT_OPT -compression $OPT_PAWZAGENT_COMPRESSION"
   fi

   if [ "$OPT_PAWZRTA_VERBOSE"  = "1" ]
   then 
       PAWZ_REALTIME_OPT="$PAWZ_REALTIME_OPT -verbose"
   fi
   if [ "$OPT_HAVE_PAWZRTA_PORT"  != "" ]
   then 
       PAWZ_REALTIME_OPT="$PAWZ_REALTIME_OPT -port $OPT_PAWZRTA_PORT"
   fi
   if [ "$OPT_HAVE_PAWZRTA_SCAN"  != "" ]
   then 
       PAWZ_REALTIME_OPT="$PAWZ_REALTIME_OPT -scan $OPT_PAWZRTA_SCAN"
   fi
   if [ "$OPT_PAWZRTA_PROC"  = "1" ]
   then 
       PAWZ_REALTIME_OPT="$PAWZ_REALTIME_OPT -collectproc"
   fi

   return
}


ConfigureSoftware()
{
    $ECHO "-----------------------------------------"
    $ECHO " Configuring..."
    $ECHO "-----------------------------------------"

    if [ -f $OPT_INSTALLDIR/bin/ecap_monitor ]
    then
            $ECHO "$ECAP_MONITOR_OPT"
            $OPT_INSTALLDIR/bin/ecap_monitor $ECAP_MONITOR_OPT -write_config
            chmod 0744 $OPT_INSTALLDIR/settings/*.config
    fi

    if [ -f $OPT_INSTALLDIR/bin/pawzagent ]
    then
            $ECHO "$PAWZ_AGENT_OPT"
            $OPT_INSTALLDIR/bin/pawzagent $PAWZ_AGENT_OPT -write_config
            chmod 0744 $OPT_INSTALLDIR/settings/*.config
    fi

    if [ -f $OPT_INSTALLDIR/bin/pawzrta ]
    then
            $ECHO "$PAWZ_REALTIME_OPT"
            $OPT_INSTALLDIR/bin/pawzrta $PAWZ_REALTIME_OPT -write_config
            chmod 0744 $OPT_INSTALLDIR/settings/*.config
    fi

    # now do options, after command line has been handled.
  
    if [ "$OPT_SILENT"  =  "0" ]
    then
        if [ -f $OPT_INSTALLDIR/bin/ecap_configure ]
        then
             $OPT_INSTALLDIR/bin/ecap_configure
        fi
        if [ -f $OPT_INSTALLDIR/bin/pawz_configure ]
        then
             $OPT_INSTALLDIR/bin/pawz_configure
        fi
    fi

    return
}

SetupInitD()
{
    if [ $INSTALL_DC -eq 0 ]
    then
          return
    fi

    if [ "$OS" = "AIX" ]
    then
        cp $OPT_INSTALLDIR/settings/perfcap.initd  /etc/rc.d/perfcap
            chown root:system /etc/rc.d/perfcap
            chmod 0755 /etc/rc.d/perfcap
            ln -fs /etc/rc.d/perfcap /etc/rc.d/rc2.d/S90perfcap
            ln -fs /etc/rc.d/perfcap /etc/rc.d/rc3.d/K90perfcap
            ln -fs /etc/rc.d/perfcap /etc/rc.d/rc4.d/K90perfcap
            ln -fs /etc/rc.d/perfcap /etc/rc.d/rc5.d/K90perfcap
            ln -fs /etc/rc.d/perfcap /etc/rc.d/rc6.d/K90perfcap
            ln -fs /etc/rc.d/perfcap /etc/rc.d/rc7.d/K90perfcap
            ln -fs /etc/rc.d/perfcap /etc/rc.d/rc8.d/K90perfcap
            ln -fs /etc/rc.d/perfcap /etc/rc.d/rc9.d/K90perfcap
    fi

    if [ "$OS" = "SunOS" ]
    then

       if [ "$OSREL" = "5.9" ] || [ "$OSREL" = "5.8" ] || [ "$OSREL" = "5.7" ]
       then

        if [  -f /etc/init.d/perfcap ]
        then
            $ECHO "Replacing /etc/init.d..."
        fi

#        if [ ! -f /etc/init.d/perfcap ]
#        then
            cp $OPT_INSTALLDIR/init.d/perfcap  /etc/init.d/perfcap
            chown root:sys /etc/init.d/perfcap
            chmod 0755 /etc/init.d/perfcap

            if [ ! -f /etc/rc3.d/S90perfcap ]
            then
               ln -fs /etc/init.d/perfcap /etc/rc3.d/S90perfcap
            fi
            if [ ! -f /etc/rc0.d/K90perfcap ]
            then
               ln -fs /etc/init.d/perfcap /etc/rc0.d/K90perfcap
            fi
       fi
    fi

    if [ "$OS" = "OSF1" ]
    then
        if [ ! -f /sbin/init.d/perfcap ]
        then
            cp $OPT_INSTALLDIR/settings/perfcap.initd  /sbin/init.d/perfcap
            chown bin:bin /sbin/init.d/perfcap
            chmod 0755 /sbin/init.d/perfcap
            ln -fs /sbin/init.d/perfcap /sbin/rc3.d/S90perfcap
            ln -fs /sbin/init.d/perfcap /sbin/rc0.d/K90perfcap
            chown root:bin /sbin/rc3.d/S90perfcap
            chown root:bin /sbin/rc0.d/K90perfcap
        fi 
    fi
    if [ "$OS" = "HP-UX" ]
    then
        if [ ! -f /sbin/init.d/perfcap ]
        then
            cp $OPT_INSTALLDIR/settings/perfcap.initd  /sbin/init.d/perfcap
            chown bin:bin /sbin/init.d/perfcap
            chmod 0755 /sbin/init.d/perfcap
            ln -fs /sbin/init.d/perfcap /sbin/rc3.d/S90perfcap
            ln -fs /sbin/init.d/perfcap /sbin/rc0.d/K90perfcap
        fi 
    fi
    if [ "$OS" = "Linux" ]
    then
        # suse...
        if [  -d /etc/init.d ]
        then
           if [ ! -f /etc/init.d/perfcap ]
           then
               cp $OPT_INSTALLDIR/settings/perfcap.initd  /etc/init.d/perfcap
               chown root:root /etc/init.d/perfcap
               chmod 0755 /etc/init.d/perfcap 
               /sbin/chkconfig --add perfcap
            fi 
        fi
        # redhat
        if [  -d /etc/rc.d/init.d ]
        then
           if [ ! -f /etc/rc.d/init.d/perfcap ]
           then
                cp $OPT_INSTALLDIR/settings/perfcap.initd  /etc/rc.d/init.d/perfcap
               chown root:root /etc/rc.d/init.d/perfcap
               chmod 0755 /etc/rc.d/init.d/perfcap 
               /sbin/chkconfig --add perfcap
            fi 
        fi
    fi
    return
}

#-----------------------------------------------------------------
PostInstall()
{
   if [ "$OS" != "SunOS" ] 
   then
      if [ $INSTALL_DC -eq 1 ]
      then
         if [ ! -f  /usr/bin/ecap_monitor ]
        then
        $ECHO "Post Install validation failed, missing /usr/bin/ecap_monitor"
         fi
      fi
   fi

   if [ ! -d "$DEFAULT_INSTALLDIR/data" ]
   then
      $ECHO "Post Install validation failed, missing data folder!"
   fi
   return
}

#-----------------------------------------------------------------
StartSoftware()
{
    $ECHO "-----------------------------------------"
    $ECHO " Starting..."
    $ECHO "-----------------------------------------"

    if [ "$OS" = "SunOS" ]
    then
        if [ "$OSREL" != "5.9" ] && [ "$OSREL" != "5.8" ] && [ "$OSREL" != "5.7" ]
         then
            svcadm enable application/perfcap:default
            svcadm restart perfcap
         else
          sh /etc/init.d/perfcap start
         fi
    fi 
    if [ "$OS" = "OSF1" ]
    then
        sh /sbin/init.d/perfcap start
    fi
    if [ "$OS" = "HP-UX" ]
    then
        sh /sbin/init.d/perfcap start 
    fi
    if [ "$OS" = "AIX" ]
    then
        sh /etc/rc.d/perfcap start 
    fi
    if [ "$OS" = "Linux" ]
    then
         # suse
        if [  -f /etc/init.d/perfcap ]
        then
            sh /etc/init.d/perfcap start 
        # redhat
        elif [  -f /etc/rc.d/init.d/perfcap ]
        then
            sh /etc/rc.d/init.d/perfcap start 
        fi
    fi

    if [ ! -f "$OPT_INSTALLDIR/ecap-monitor.txt" ]
    then
           $ECHO " "
           $ECHO " eCap Monitor license file required to run ecap_monitor"
           $ECHO " $OPT_INSTALLDIR/ecap-monitor.txt  not found"
           $ECHO "executing  /usr/bin/ecap_monitor ..."
           /usr/bin/ecap_monitor
           $ECHO " "
   fi

   return
}

#-----------------------------------------------------------------



#------------------------------------------------------
# MAIN ENTRY
#------------------------------------------------------

   SetupEnv

   ValidateOS

   if [ ! -d "$KIT_OS_MEDIA_ROOT" ]
   then
     $ECHO "The Media for this platform does not exist in the installation folder."
     $ECHO "$KIT_OS_MEDIA_ROOT is missing"
     exit 0
   fi
   DefaultComponents

   GetCmdLine $@

   if [ $OPT_HELP = "1" ]
   then
       ShowCommandLineOptions
       exit 1
   fi

   ValidateCmdLine

   if [ $OPT_SILENT = "0" ]
   then
      SelectComponents  # query user for options
   fi

  # Set Install Flags

   UpdateInstallFlags

   GetExistingSettings

   GetLicenseFile

   GetCurrentSettings

   GetInstallPath

   GetLicensePath

   CreateCmdLine

   ShowInstallationSelections

   UninstallExisting

   PreInstall 

   InstallSoftware

   ConfigureSoftware

   SetupInitD

   PostInstall

   StartSoftware

   $ECHO "---------------------------------------------------"
   $ECHO "Installation Complete."
   $ECHO " "
   exit 0
