#!/bin/sh
#
# Copyright(c) 2002, PerfCap Corporation, Nashua NH
#
# Sample script to illustrate how the ecap_graph 
# utility is called for UNIX platforms
#
# Notes:
#    Modify the date and run
#    hostname can not return fully quailfied hostname
#    if it does, replace it with your hostname
# 
#-------------------------------------------------

# add a path when using crontab
# OUTPUT_DIR="/tmp"

#OUTPUT_DIR="/cp1/nightly"
OUTPUT_DIR="`pwd`"

ARG="$1"

if [ "$ARG" = "" ] 
then
   ARG="yesterday"
fi

ddd="`date +%d`"
MMM="`date +%h`"
YYY="`date +%Y`"

#------------------------------------------------
# Parse out Date 
#-----------------------------------------------

if [ "$ARG" = "today" ] 
then

  #---------------------------------
  # Get Todays date
  #---------------------------------

  ddd="`date +%d`"
  MMM="`date +%h`"
  YYY="`date +%Y`"
  HHH="`date +%H`"
  MIN="`date +%M`"

  STARTTIME=$ddd"-"$MMM"-"$YYY":00:00:00"
  ENDTIME=$ddd"-"$MMM"-"$YYY":"$HHH":"$MIN":00"
  CPC_DATE="`date +20%y%h%d`"
  OUT_DATE="`date +20%y%h%d_%H_%M`"
else

#---------------------------------
# Get Yesterdays date
#---------------------------------

   MONTH_NUM=`date +%m`
   DAY_NUM=`date +%d`
   YEAR_NUM=`date +%Y`
    
   MONTH_NUM=`expr $MONTH_NUM + 0`
   DAY_NUM=`expr $DAY_NUM - 1`
  
   if [ $DAY_NUM -eq 0 ]
   then
    
    MONTH_NUM=`expr $MONTH_NUM - 1`  
  
    if [ $MONTH_NUM -eq 0 ]
    then
        MONTH_NUM=12
        DAY_NUM=31
        YEAR_NUM=`expr $YEAR_NUM - 1`  
  
    # find last DAY_NUM
  
    else
  
      case $MONTH_NUM in
        1|3|5|7|8|10|12) DAY_NUM=31;;
        4|6|9|11) DAY_NUM=30;;
        2)
          if [ `expr $YEAR_NUM % 4` -eq 0 ]; then
            if [ `expr $YEAR_NUM % 400` -eq 0 ]; then
              DAY_NUM=29
            elif [ `expr $YEAR_NUM % 100` -eq 0 ]; then
              DAY_NUM=28
            else
              DAY_NUM=29
            fi
          else
            DAY_NUM=28
          fi
        ;;
      esac
    fi
  fi
  
  # get MONTH_NUM string
  
  
  MONTH_NUM_STR="Jan"
  case $MONTH_NUM in
        1)
           MONTH_STR="Jan"
           ;;
        2)
           MONTH_STR="Feb"
           ;;
        3)
           MONTH_STR="Mar"
           ;;
        4)
           MONTH_STR="Apr"
           ;;
        5)
           MONTH_STR="May"
           ;;
        6)
           MONTH_STR="Jun"
           ;;
        7)
           MONTH_STR="Jul"
           ;;
        8)
           MONTH_STR="Aug"
           ;;
        9)
           MONTH_STR="Sep"
           ;;
        10)
           MONTH_STR="Oct"
           ;;
        11)
           MONTH_STR="Nov"
           ;;
        12)
           MONTH_STR="Dec"
           ;;
   esac

  ddd=$DAY_NUM
  case $DAY_NUM in
        1)
           ddd="01"
           ;;
        2)
           ddd="02"
           ;;
        3)
           ddd="03"
           ;;
        4)
           ddd="04"
           ;;
        5)
           ddd="05"
           ;;
        6)
           ddd="06"
           ;;
        7)
           ddd="07"
           ;;
        8)
           ddd="08"
           ;;
        9)
           ddd="09"
           ;;
   esac
 
  MMM=$MONTH_STR
  YYY=$YEAR_NUM
  STARTTIME=$ddd"-"$MMM"-"$YYY":00:00:00"
  ENDTIME=$ddd"-"$MMM"-"$YYY":23:59:00"
  CPC_DATE="$YYY$MMM$ddd"
  OUT_DATE=$YYY$MMM$ddd"_23_59"
fi

#------------------------------------------------
# Build up TIME Strings and other output 
#-----------------------------------------------


 HOSTNAME=`hostname`

 DATAFILE=""
 IMAGE="/usr/bin/ecap_graph"

#------------------------------------------------
# Determine Data File 
#-----------------------------------------------

OS=`uname -s`
if [ ${OS} = "OSF1" ] 
then
  HOSTNAME=`hostname -s`
  DATAFILE="/usr/opt/perfcap/data/ecp_"$HOSTNAME"_"$CPC_DATE".cpc-1"
  IMAGE="/usr/opt/perfcap/bin/ecap_graph"
fi
if [ ${OS} = "AIX" ] 
then
  HOSTNAME=`hostname -s`
  DATAFILE="/usr/perfcap/data/ecpa_"$HOSTNAME"_"$CPC_DATE".cpc-1"
  IMAGE="/usr/perfcap/bin/ecap_graph"
fi
if [ ${OS} = "SunOS" ] 
then
  DATAFILE="/opt/perfcap/data/ecps_"$HOSTNAME"_"$CPC_DATE".cpc-1"
  IMAGE="/opt/perfcap/bin/ecap_graph"
fi
if [ ${OS} = "HP-UX" ] 
then
  DATAFILE="/opt/perfcap/data/ecph_"$HOSTNAME"_"$CPC_DATE".cpc-1"
  IMAGE="/opt/perfcap/bin/ecap_graph"
fi
if [ ${OS} = "Linux" ] 
then
  HOSTNAME=`hostname -s`
  DATAFILE="/usr/local/perfcap/data/ecpl_"$HOSTNAME"_"$CPC_DATE".cpc-1"
  IMAGE="/usr/local/perfcap/bin/ecap_graph"
fi

echo " "
echo " Data File  : $DATAFILE"
echo " Start Time : $STARTTIME"
echo " End Time   : $ENDTIME"
echo " "

#------------------------------------
# CPU Metrics
#------------------------------------

TYPE_LIST="csv gif jpg ps"
CPU_ITEM_LIST="overallcpuutilization \
               overallcpuutilizationbymode \
               overallcpuutilizationperprocessor\
               top10imagesbycpuutilization \
               top10usersbycpuutilization \
               cpuutilizationofworkloadclasses"

for ITEM in $CPU_ITEM_LIST
do
   for ITEM_TYPE in $TYPE_LIST
   do
      echo "ecap_graph for " $ITEM " type " $ITEM_TYPE
      $IMAGE -cpcunix $DATAFILE \
          -begin $STARTTIME  -end $ENDTIME  \
          -graph $OUTPUT_DIR"/"$HOSTNAME"_"$ITEM"_"$OUT_DATE"."$ITEM_TYPE \
          -type $ITEM_TYPE \
          -item $ITEM  1> /dev/null
    done
done


   ITEM="overalldiski/ooperationrate"
   for ITEM_TYPE in $TYPE_LIST
   do
      echo "ecap_graph for " $ITEM " type " $ITEM_TYPE
      $IMAGE -cpcunix $DATAFILE \
          -begin $STARTTIME  -end $ENDTIME  \
          -graph $OUTPUT_DIR"/"$HOSTNAME"_disk_io_operation_rate_"$OUT_DATE"."$ITEM_TYPE \
          -type $ITEM_TYPE \
          -item $ITEM  1> /dev/null
    done

   ITEM="overalldiski/oratebytype"
   for ITEM_TYPE in $TYPE_LIST
   do
      echo "ecap_graph for " $ITEM " type " $ITEM_TYPE
      $IMAGE -cpcunix $DATAFILE \
          -begin $STARTTIME  -end $ENDTIME  \
          -graph $OUTPUT_DIR"/"$HOSTNAME"_disk_io_rate_by_type_"$OUT_DATE"."$ITEM_TYPE \
          -type $ITEM_TYPE \
          -item $ITEM  1> /dev/null
    done

   ITEM="top10disksbyi/ooperations"
   for ITEM_TYPE in $TYPE_LIST
   do
      echo "ecap_graph for " $ITEM " type " $ITEM_TYPE
      $IMAGE -cpcunix $DATAFILE \
          -begin $STARTTIME  -end $ENDTIME  \
          -graph $OUTPUT_DIR"/"$HOSTNAME"_top_disk_by_io_"$OUT_DATE"."$ITEM_TYPE \
          -type $ITEM_TYPE \
          -item $ITEM  1> /dev/null
    done

#-------------------------------------
# FS Metrics
#-------------------------------------

FS_ITEM_LIST="toptenfilesystemsbydiskspace"

for ITEM in $FS_ITEM_LIST
do
   for ITEM_TYPE in $TYPE_LIST
   do
      echo "ecap_graph for " $ITEM " type " $ITEM_TYPE
      $IMAGE -cpcunix $DATAFILE \
          -begin $STARTTIME  -end $ENDTIME  \
          -graph $OUTPUT_DIR"/"$HOSTNAME"_"$ITEM"_"$OUT_DATE"."$ITEM_TYPE \
          -type $ITEM_TYPE \
          -item $ITEM  1> /dev/null
    done
done

#
# memory 
#

MEM_ITEM_LIST="memoryutilization 
               memoryallocation
               pagefaultrate 
               pagefaultsbytype"

for ITEM in $MEM_ITEM_LIST
do
   for ITEM_TYPE in $TYPE_LIST
   do
      echo "ecap_graph for " $ITEM " type " $ITEM_TYPE
      $IMAGE -cpcunix $DATAFILE \
          -begin $STARTTIME  -end $ENDTIME  \
          -graph $OUTPUT_DIR"/"$HOSTNAME"_"$ITEM"_"$OUT_DATE"."$ITEM_TYPE \
          -type $ITEM_TYPE \
          -item $ITEM  1> /dev/null
    done
done

   ITEM="pagefaulti/o"
   for ITEM_TYPE in $TYPE_LIST
   do
      echo "ecap_graph for " $ITEM " type " $ITEM_TYPE
      $IMAGE -cpcunix $DATAFILE \
          -begin $STARTTIME  -end $ENDTIME  \
          -graph $OUTPUT_DIR"/"$HOSTNAME"_pf_io_"$OUT_DATE"."$ITEM_TYPE \
          -type $ITEM_TYPE \
          -item $ITEM  1> /dev/null
    done
#
# network
#
NET_ITEM_LIST="tcppacketrate
               tcpdatarate
               tcpsentpacketsbreakdown
               tcpreceivedpacketsbreakdown
               tcpconnectionsclosed
               tcpconnectionsestablished 
               udppacketrate 
               ippacketrate"

for ITEM in $NET_ITEM_LIST
do
   for ITEM_TYPE in $TYPE_LIST
   do
      echo "ecap_graph for " $ITEM " type " $ITEM_TYPE
      $IMAGE -cpcunix $DATAFILE \
          -begin $STARTTIME  -end $ENDTIME  \
          -graph $OUTPUT_DIR"/"$HOSTNAME"_"$ITEM"_"$OUT_DATE"."$ITEM_TYPE \
          -type $ITEM_TYPE \
          -item $ITEM  1> /dev/null
    done
done


#
# processes
#
PRC_ITEM_LIST="processcount 
               processcountbyworkloadclasses"
for ITEM in $PRC_ITEM_LIST
do
   for ITEM_TYPE in $TYPE_LIST
   do
      echo "ecap_graph for " $ITEM " type " $ITEM_TYPE
      $IMAGE -cpcunix $DATAFILE \
          -begin $STARTTIME  -end $ENDTIME  \
          -graph $OUTPUT_DIR"/"$HOSTNAME"_"$ITEM"_"$OUT_DATE"."$ITEM_TYPE \
          -type $ITEM_TYPE \
          -item $ITEM  1> /dev/null
    done
done

exit 0
