#!/bin/sh
#
# PerfCap Uninstallation script for UNIX
#
# Copyright (c) 2012, PerfCap Corporation, Nashua NH
# All Rights Reserved
#                        - all unix , fix for sun remove dc
#------------------------------------------------------------

ACTUAL_INSTALL_DIR=""
ACTUAL_DATA_DIR=""

INSTALL_DIR="/usr/opt/perfcap"
OS=`uname -s`
OSVER=`uname -v`
OSREL=`uname -r`
ECHO="echo"
ECHON="echo -n"
PLATFORM=""
PLAT=""
IS_SILENT=0
IS_COMPLETE=0
USE_ECHO_N=0

#--------------------------------------------
# setup
#--------------------------------------------
SetupEnv()
{
   if [ "$OS" = "AIX" ]
   then
       ECHO="echo"
       INSTALL_DIR="/usr/perfcap"
   fi
   if [ "$OS" = "SunOS" ]
   then
       ECHO="/usr/bin/echo"
       INSTALL_DIR="/opt/perfcap"
   fi
   if [ "$OS" = "OSF1" ]
   then
       ECHO="echo"
       INSTALL_DIR="/usr/opt/perfcap"
   fi
   if [ "$OS" = "HP-UX" ]
   then
       ECHO="echo"
       INSTALL_DIR="/opt/perfcap"
   fi
   if [ "$OS" = "Linux" ]
   then
       ECHO="/bin/echo"
       INSTALL_DIR="/usr/local/perfcap"
       USE_ECHO_N=1
   fi
   # set defaults 
   UNINSTALL_RT=1
   UNINSTALL_PAWZ=1
   UNINSTALL_PLAN=1
   UNINSTALL_DB=1
   UNINSTALL_RN=1
   UNINSTALL_DC=1
   UNINSTALL_AN=1
}

#--------------------------------------------
# default options for silent 
#--------------------------------------------

silent_uninstall()
{
   UNINSTALL_RT=1
   UNINSTALL_PAWZ=1
   UNINSTALL_PLAN=1
   UNINSTALL_DB=1
   UNINSTALL_RN=1
   UNINSTALL_DC=1
   UNINSTALL_AN=1
   return
}

#--------------------------------------------
# query options for interactive uninstall 
#--------------------------------------------

interactive_uninstall()
{
  COMPLETE_UNINSTALL=0
  while [ $DONE_SEL -eq 0 ]
  do
    POST_UNINSTALL=0
    $ECHO " eCAP & PAWZ De-installation:  complete or partial"
    $ECHO " "
    if [ $USE_ECHO_N -eq 1 ]
    then
       $ECHON " Complete or Partial uninstall of eCAP & PAWZ (c/p/q/?) : "
    else
       $ECHO " Complete or Partial uninstall of eCAP & PAWZ (c/p/q/?) : \c"
    fi

    read answer
    if [ "$answer" = '?' ] 
    then
      $ECHO " "
      $ECHO "   Complete uninstall will delete all installed components. including"
      $ECHO "    cpc data files"
      $ECHO "    license files"
      $ECHO "    installation directory"
      $ECHO "    startup files"
      $ECHO " "
      $ECHO "  Partial uninstall will delete all installed components. leaving"
      $ECHO "     cpc data files"
      $ECHO "     settings files"
      $ECHO "     license files"
      $ECHO
      COMPLETE_UNINSTALL=0
      POST_UNINSTALL=0

    elif [ "$answer" = 'Q' ] || [ "$answer" = 'q' ] || \
       [ "$answer" = "quit" ]  || [ "$answer" = "QUIT" ]; then
        exit 0
    elif [ "$answer" = 'c' ] || [ "$answer" = 'C' ] || \
         [ "$answer" = "complete" ]  || [ "$answer" = "COMPLETE" ]  ; then
         COMPLETE_UNINSTALL=1
         POST_UNINSTALL=1
    elif [ "$answer" = 'p' ] || [ "$answer" = 'P' ] || \
         [ "$answer" = "partial" ]  || [ "$answer" = "PARTIAL" ]  ; then
         COMPLETE_UNINSTALL=0
         POST_UNINSTALL=1
    else 
         COMPLETE_UNINSTALL=0
         POST_UNINSTALL=0
    fi

    if [ $POST_UNINSTALL -eq 1 ]
    then
        $ECHO " "
        $ECHO "The following has been selected "
        $ECHO " "

       if [ $COMPLETE_UNINSTALL -eq 1 ]
       then 
           $ECHO "  Complete uninstall: "
           $ECHO "      Remove eCAP/PAWZ Components"
           $ECHO "      Remove eCAP data files"
           $ECHO "      Remove Install directory"
           $ECHO "      Remove  init.d startup files"
           $ECHO " "

           $ECHO "     This will DELETE ALL files in $ACTUAL_INSTALL_DIR"
           $ECHO "     This will DELETE ALL files in $ACTUAL_DATA_DIR"
           IS_COMPLETE=1
       else
           $ECHO "  Partial uninstall: "
           $ECHO "      Remove eCAP/PAWZ Components"
           IS_COMPLETE=0
       fi

       $ECHO  " "
       if [ $USE_ECHO_N -eq 1 ]
       then
           $ECHON " Proceed with de-installation ? (y/n/q) [n]: "
       else
           $ECHO " Proceed with de-installation ? (y/n/q) [n]: \c"
       fi
       read answer

       if [ "$answer" = 'Q' ] || [ "$answer" = 'q' ] || \
          [ "$answer" = "quit" ]  || [ "$answer" = "QUIT" ]
       then
           exit
       elif [ "$answer" = 'Y' ] || [ "$answer" = 'y' ] || \
            [ "$answer" = "yes" ]  || [ "$answer" = "YES" ]; then
           DONE_SEL=1
       else
           UNINSTALL_PLAN=0
           UNINSTALL_AN=0
           UNINSTALL_RN=0
           UNINSTALL_RT=0
           UNINSTALL_DB=0
           UNINSTALL_PAWZ=0
           UNINSTALL_DC=0
       fi 
    fi
  done

  return
}

#--------------------------------------------
# remove aix 
#--------------------------------------------

remove_aix()
{
    if [ $UNINSTALL_RT -eq 1 ]
    then
        echo "Removing PerfCap.PawzRealtime .."
        /usr/lib/instl/sm_inst installp_cmd -u -f'PerfCap.PawzRealtime'
    fi

    if [ $UNINSTALL_PAWZ -eq 1 ]
    then
        echo "Removing PerfCap.PawzAgent ..."
        /usr/lib/instl/sm_inst installp_cmd -u -f'PerfCap.PawzAgent'
    fi


    if [ $UNINSTALL_PLAN -eq 1 ]
    then
        echo "Removing PerfCap.PerfCapPlan .."
        /usr/lib/instl/sm_inst installp_cmd -u -f'PerfCap.PerfCapPlan'
    fi

    if [ $UNINSTALL_AN -eq 1 ]
    then
        echo "Removing PerfCap.PerfCapAnalyze.."
        /usr/lib/instl/sm_inst installp_cmd -u -f'PerfCap.PerfCapAnalyze'
    fi
    if [ $UNINSTALL_DB -eq 1 ]
    then
        echo "Removing PerfCap.PerfCapDb..."
        /usr/lib/instl/sm_inst installp_cmd -u -f'PerfCap.PerfCapDb'
    fi

    if [ $UNINSTALL_DC -eq 1 ]
    then
       echo "Removing PerfCap.PerfCapMonitor..."
       /usr/lib/instl/sm_inst installp_cmd -u -f'PerfCap.PerfCapMonitor'
    fi
    if [ $UNINSTALL_RN -eq 1 ]
    then
        echo "Removing PerfCap.PerfCapRelnotes .."
        /usr/lib/instl/sm_inst installp_cmd -u -f'PerfCap.PerfCapRelnotes'
    fi
    if [ $IS_COMPLETE -eq 1 ]
    then
         /usr/bin/echo " "
         /usr/bin/echo " Removing init.d files..."
         rm -f /etc/rc.d/perfcap
         rm -f /etc/rc.d/rc2.d/S*perfcap
         rm -f /etc/rc.d/rc3.d/K*perfcap
         rm -f /etc/rc.d/rc4.d/K*perfcap
         rm -f /etc/rc.d/rc5.d/K*perfcap
         rm -f /etc/rc.d/rc6.d/K*perfcap
         rm -f /etc/rc.d/rc7.d/K*perfcap
         rm -f /etc/rc.d/rc8.d/K*perfcap
         rm -f /etc/rc.d/rc8.d/K*perfcap
    fi
    return
}


#--------------------------------------------
# remove sun 
#--------------------------------------------

remove_sun()
{

   FOUND=0
    if [ $UNINSTALL_RT -eq 1 ]
    then
       FOUND=1
       if [ -d /var/sadm/pkg/PerfCapRT ]
       then 
          /usr/bin/echo " "
          /usr/bin/echo "Removing PerfCapRT:  PAWZ Agent Realtime .."
          if [ -f $INSTALL_DIR/settings/perfcap_admin ]
          then
               pkgrm -n -a $INSTALL_DIR/settings/perfcap_admin PerfCapRT
          else
              pkgrm  PerfCapRT
          fi 
       fi
    fi

    if [ $UNINSTALL_PAWZ -eq 1 ]
    then
        FOUND=1
        if [ -d /var/sadm/pkg/PerfCapPZ ]
        then 
            /usr/bin/echo " "
            /usr/bin/echo "Removing PerfCapPZ:  PAWZ Agent .."
            if [ -f $INSTALL_DIR/settings/perfcap_admin ]
            then
                pkgrm -n -a $INSTALL_DIR/settings/perfcap_admin PerfCapPZ
            else
                 pkgrm PerfCapPZ
            fi
         fi
    fi

    if [ $UNINSTALL_RN -eq 1 ]
    then
       FOUND=1
        if [ -d /var/sadm/pkg/PerfCapRN ]
        then 
            /usr/bin/echo " "
            /usr/bin/echo "Removing PerfCapRN:  Release Notes .."
            if [ -f $INSTALL_DIR/settings/perfcap_admin ]
            then
                pkgrm -n -a $INSTALL_DIR/settings/perfcap_admin PerfCapRN
            else
                pkgrm PerfCapRN
             fi
        fi
    fi

    if [ $UNINSTALL_PLAN -eq 1 ]
    then
        FOUND=1
        if [ -d /var/sadm/pkg/PerfCapPL ]
        then 
            /usr/bin/echo " "
            /usr/bin/echo "Removing PerfCapPL:  eCAP Capacity Planner .."
            if [ -f $INSTALL_DIR/settings/perfcap_admin ]
            then
                pkgrm -n -a $INSTALL_DIR/settings/perfcap_admin PerfCapPL
            else
                pkgrm PerfCapPL
            fi
        fi
    fi

    if [ $UNINSTALL_AN -eq 1 ]
    then
        FOUND=1
        if [ -d /var/sadm/pkg/PerfCapAN ]
        then 
           /usr/bin/echo " "
           /usr/bin/echo "Removing PerfCapAN:   eCAP Analyzer .."
           if [ -f $INSTALL_DIR/settings/perfcap_admin ]
           then
               pkgrm -n -a $INSTALL_DIR/settings/perfcap_admin PerfCapAN
           else
               pkgrm PerfCapAN
           fi
       fi
    fi
   if [ $FOUND -eq 0 ]
   then
      /usr/bin/echo "No PerfCap Products found."
      /usr/bin/echo "try pkginfo | grep PerfCap"
   fi  


    if [ $UNINSTALL_DC -eq 1 ]
    then
        FOUND=1
        if [ -d /var/sadm/pkg/PerfCapDC ]
        then 
           /usr/bin/echo " "
           /usr/bin/echo "Removing PerfCapDC ecap_monitor .."
           if [ -f $INSTALL_DIR/settings/perfcap_admin ]
           then
               pkgrm -n -a $INSTALL_DIR/settings/perfcap_admin PerfCapDC
           else
               pkgrm PerfCapDC
           fi
       fi
    fi
    if [ $UNINSTALL_DB -eq 1 ]
    then
        FOUND=1
        if [ -d /var/sadm/pkg/PerfCapDB ]
        then 
            /usr/bin/echo " "
            /usr/bin/echo "Removing PerfCapDB  PerfCap Database .."
            if [ -f $INSTALL_DIR/settings/perfcap_admin ]
            then
               pkgrm -n -a $INSTALL_DIR/settings/perfcap_admin PerfCapDB
            else
               pkgrm PerfCapDB
            fi
        fi
    fi

    if [ $IS_COMPLETE -eq 1 ]
    then
         /usr/bin/echo " "
         /usr/bin/echo " Removing init.d files..."
         rm -f /etc/rc0.d/K*perfcap
         rm -f /etc/rc3.d/S*perfcap
         rm -f /etc/init.d/perfcap*
    fi
    return
}

#------------------------------------------
# remove tru64 comps
#------------------------------------------

remove_tru()
{
    FOUND=0
    if [ $UNINSTALL_RT -eq 1 ] 
    then
        FOUND=1
        $ECHO "Removing PERFCAPREALTIME1000..."
        /usr/sbin/setld -d PERFCAPREALTIME1000 
    fi

   if [ $UNINSTALL_PAWZ -eq 1 ]
   then
        FOUND=1
        $ECHO "Removing PERFCAPPAWZ1000.."
        /usr/sbin/setld -d PERFCAPPAWZ1000
   fi

   if [ $UNINSTALL_RN -eq 1 ]
   then
     FOUND=1
     $ECHO "Removing PERFCAPRELNOTE1000..."
     /usr/sbin/setld -d PERFCAPRELNOTE1000
   fi

   if [ $UNINSTALL_PLAN -eq 1 ]
   then
      FOUND=1
      $ECHO "Removing PERFCAPPLAN1000..."
      /usr/sbin/setld -d PERFCAPPLAN1000
   fi
   if [ $UNINSTALL_AN -eq 1 ]
   then
      FOUND=1
      $ECHO "Removing PERFCAPANALYZE100..."
      /usr/sbin/setld -d PERFCAPANALYZE1000 
   fi
   if [ $UNINSTALL_DB -eq 1 ]
   then
       FOUND=1
       $ECHO "Removing PERFCAPBASE1000..."
       /usr/sbin/setld -d PERFCAPBASE1000 
   fi

   if [ $UNINSTALL_DC -eq 1 ]
   then
       FOUND=1
       $ECHO "Removing PERFCAPMONITOR1000..."
       /usr/sbin/setld -d PERFCAPMONITOR1000 
   fi

   if [ $FOUND -eq 0 ] 
   then
       $ECHO  "No PerfCap Products found!"
       $ECHO  "try setld -i | grep PERFCAP"
   fi
    if [ $IS_COMPLETE -eq 1 ]
    then
         /usr/bin/echo " "
         /usr/bin/echo " Removing init.d files..."
         rm -f /sbin/init.d/perfcap
         rm -f /sbin/rc0.d/K*perfcap
         rm -f /sbin/rc3.d/S*perfcap
    fi
   return
}

#-----------------------------------------
# remove hpux  (pa-risc or ia64)
#-----------------------------------------

remove_hpux()
{
    HP_INSTALL_OPTS=""
    ARCH=`uname -m`
    if [ "$ARCH" = "ia64" ]
    then
       HP_UNINSTALL_OPTS="-x mount_all_filesystems=false"
    fi
    if [ $UNINSTALL_RT -eq 1 ]
    then
      echo "Removing PerfCap.PawzRealtime .."
      swremove $HP_UNINSTALL_OPTS PerfCap.PawzRealtime.RealtimeFiles
      swremove $HP_UNINSTALL_OPTS PawzRealtime
    fi
    if [ $UNINSTALL_PAWZ -eq 1 ]
    then
      echo "Removing PerfCap.PawzAgent ..."
      swremove $HP_UNINSTALL_OPTS PerfCap.PawzAgent.AgentFiles
      swremove $HP_UNINSTALL_OPTS PawzAgent
    fi
    if [ $UNINSTALL_PLAN -eq 1 ]
    then
      echo "Removing PerfCap.PerfCapPlan .."
      swremove $HP_UNINSTALL_OPTS PerfCap.PerfCapPlan.PlanFiles
      swremove $HP_UNINSTALL_OPTS PerfCapPlan
    fi
    if [ $UNINSTALL_AN -eq 1 ]
    then
      echo "Removing PerfCap.PerfCapAnalyze.."
      swremove $HP_UNINSTALL_OPTS PerfCap.PerfCapAnalyze.AnalyzeFiles
      swremove $HP_UNINSTALL_OPTS PerfCapAnalyze
    fi
    if [ $UNINSTALL_DB -eq 1 ]
    then
       echo "Removing PerfCap.PerfCapDb..."
       swremove $HP_UNINSTALL_OPTS PerfCap.PerfCapDb.DbFiles
      swremove $HP_UNINSTALL_OPTS PerfCapDb
    fi
    if [ $UNINSTALL_DC -eq 1 ]
    then
      echo "Removing PerfCap.PerfCapMonitor..."
      swremove $HP_UNINSTALL_OPTS PerfCap.PerfCapMonitor.MonFiles
      swremove $HP_UNINSTALL_OPTS PerfCapMonitor
   fi
    if [ $UNINSTALL_RN -eq 1 ]
    then
      echo "Removing PerfCap.PerfCapRelnotes .."
      swremove $HP_UNINSTALL_OPTS PerfCap.PerfCapRelNotes.RelNotesFiles
      swremove $HP_UNINSTALL_OPTS PerfCapRelNotes
    fi
    if [ $IS_COMPLETE -eq 1 ]
    then
         /usr/bin/echo " "
         /usr/bin/echo " Removing init.d files..."
         rm -f /sbin/init.d/perfcap
         rm -f /sbin/rc0.d/K*perfcap
         rm -f /sbin/rc3.d/S*perfcap
    fi
   return
}

#--------------------------------------------
# remove linux 
#--------------------------------------------

remove_linux_ia64()
{

    echo " Remove LINUX ia64 "
    echo " "
    if [ $UNINSTALL_RT -eq 1 ]
    then
        echo "Removing PerfCap.PawzRealtime .."
        if [ -x /usr/bin/pawzrta ]; then
            /usr/bin/pawzrta -stop
            sleep 1
        fi

        if [ -h /usr/share/man/man1/pawzrta.1 ]
        then
            rm /usr/share/man/man1/pawzrta.1
        fi
        rm -r /usr/local/perfcap/bin/pawzrta
        rm -rf /usr/local/perfcap/logs/rta*.log
        rm -rf /usr/local/perfcap/man/pawzrta.1
        rm -rf /usr/local/perfcap/settings/.install_rt
        rm -rf /usr/local/perfcap/settings/.uninstall_rt

        if [ -h /usr/bin/pawzrta ]; then
            rm -r /usr/bin/pawzrta
        fi

       relink_uninstall

    fi
   if [ $UNINSTALL_PAWZ -eq 1 ]
    then
        echo "Removing PerfCap.PawzAgent ..."
        if [ -x /usr/bin/pawzagent ] ; then
            /usr/bin/pawzagent -stop
            sleep 2
        fi

        if [ -f /usr/local/perfcap/bin/pawzagent ] ; then
                 /usr/local/perfcap/bin/pawzagent -stop > /dev/null 2>&1
        fi

        if [ -h /usr/share/man/man1/pawzagent.1 ]
        then
            rm /usr/share/man/man1/pawzagent.1
        fi

        rm -r /usr/local/perfcap/bin/pawzagent
        rm -r /usr/local/perfcap/bin/pawz_configure
        rm -r /usr/local/perfcap/bin/pawzperf

        rm -rf /usr/local/perfcap/logs/pawz*.log
        rm -f /usr/local/perfcap/man/pawzagent.1
        rm -rf /usr/local/perfcap/settings/.install_pawz
        rm -rf /usr/local/perfcap/settings/.uninstall_pawz
        if [ -h /usr/bin/pawzagent ] ; then
            rm -r /usr/bin/pawzagent
        fi
       relink_uninstall
    fi

    if [ $UNINSTALL_RN -eq 1 ]
    then
        echo "Removing PerfCap.PerfCapRelnotes .."
        rm -rf /usr/local/perfcap/docs
        rm -rf /usr/local/perfcap/settings/.install_rn
        rm -rf /usr/local/perfcap/settings/.uninstall_rn
        relink_uninstall
    fi

    if [ $UNINSTALL_AN -eq 1 ]
    then
        echo "Removing PerfCap.PerfCapAnalyze.."
        rm -f /usr/local/perfcap/bin/ecap_analyze
        # rm -f /usr/local/perfcap/bin/ecap_graph
        # rm -f /usr/local/perfcap/bin/ecap_export
        rm -f /usr/local/perfcap/bin/ecap_export.sh
        rm -rf /usr/local/perfcap/settings/.install_an
        rm -rf /usr/local/perfcap/settings/.uninstall_an
        rm -f /usr/local/perfcap/man/ecap_analyze.1
        if [ -h /usr/bin/ecap_analyze ]
        then
            rm -f /usr/bin/ecap_analyze
        fi
        if [ -h /usr/bin/ecap_export ]
        then
            rm -f /usr/bin/ecap_export
        fi
        if [ -h /usr/bin/ecap_graph ]
        then
            rm -f /usr/bin/ecap_graph
        fi
        relink_uninstall
    fi
   if [ $UNINSTALL_DB -eq 1 ]
    then
        echo "Removing PerfCap.PerfCapDb..."
        rm -rf /usr/local/perfcap/db
        rm -f /usr/local/perfcap/settings/.install_db
        rm -f /usr/local/perfcap/settings/.uninstall_db
        relink_uninstall
    fi

    if [ $UNINSTALL_DC -eq 1 ]
    then
       echo "Removing PerfCap.PerfCapMonitor..."
        if [ -x /usr/bin/ecap_monitor ] ; then
           /usr/bin/ecap_monitor -stop
           sleep 1
        fi

    if [ -h /usr/share/man/man1/cpcunix.1 ]
        then
            rm /usr/share/man/man1/cpcunix.1
        fi
        rm -f /usr/local/perfcap/logs/ecp*.log
        rm -f /usr/local/perfcap/bin/ecap_monitor
        rm -f /usr/local/perfcap/bin/ecap_configure
        rm -f /usr/local/perfcap/man/ecap_monitor.1
        rm -f /usr/local/perfcap/settings/.install_dc
        rm -f /usr/local/perfcap/settings/.uninstall_dc
        rm -f /usr/local/perfcap/man/ecap_monitor.1
        if [ -h /usr/bin/ecap_monitor ] ; then
           rm -r /usr/bin/ecap_monitor
        fi
        relink_uninstall
    fi
    if [ $IS_COMPLETE -eq 1 ]
    then
         /usr/bin/echo " "
         /usr/bin/echo " Removing init.d files..."
         /sbin/chkconfig --del perfcap
         if [ -f /etc/rc.d/init.d/perfcap ]
         then
            rm -f /etc/rc.d/init.d/perfcap
         fi
         if [ -f /etc/rc.d/perfcap ]
         then
            rm -f /etc/rc.d/perfcap
         fi
    fi
   return
}

remove_linux()
{
    echo " "
    if [ $UNINSTALL_RT -eq 1 ]
    then
        echo "Removing PerfCap.PawzRealtime .."
        if [ -x /usr/bin/pawzrta ]; then
            /usr/bin/pawzrta -stop
            sleep 1
        fi

        if [ -h /usr/share/man/man1/pawzrta.1 ]
        then
            rm /usr/share/man/man1/pawzrta.1
        fi
        rm -r /usr/local/perfcap/bin/pawzrta
        rm -r /usr/local/perfcap/bin_i386/pawzrta
        rm -r /usr/local/perfcap/bin_x64/pawzrta
        rm -rf /usr/local/perfcap/logs/rta*.log
        rm -rf /usr/local/perfcap/man/pawzrta.1
        rm -rf /usr/local/perfcap/settings/.install_rt
        rm -rf /usr/local/perfcap/settings/.uninstall_rt

        if [ -h /usr/bin/pawzrta ]; then
            rm -r /usr/bin/pawzrta
        fi

       relink_uninstall

    fi
   if [ $UNINSTALL_PAWZ -eq 1 ]
    then
        echo "Removing PerfCap.PawzAgent ..."
        if [ -x /usr/bin/pawzagent ] ; then
            /usr/bin/pawzagent -stop
            sleep 2
        fi

        if [ -f /usr/local/perfcap/bin/pawzagent ] ; then
                 /usr/local/perfcap/bin/pawzagent -stop > /dev/null 2>&1
        fi

        if [ -h /usr/share/man/man1/pawzagent.1 ]
        then
            rm /usr/share/man/man1/pawzagent.1
        fi

        rm -r /usr/local/perfcap/bin/pawzagent
        rm -r /usr/local/perfcap/bin/pawz_configure
        rm -r /usr/local/perfcap/bin/pawzperf
        rm -r /usr/local/perfcap/bin_i386/pawzagent
        rm -r /usr/local/perfcap/bin_i386/pawz_configure
        rm -r /usr/local/perfcap/bin_i386/pawzperf
        rm -r /usr/local/perfcap/bin_x64/pawzagent
        rm -r /usr/local/perfcap/bin_x64/pawz_configure
        rm -r /usr/local/perfcap/bin_x64/pawzperf

        rm -rf /usr/local/perfcap/logs/pawz*.log
        rm -f /usr/local/perfcap/man/pawzagent.1
        rm -rf /usr/local/perfcap/settings/.install_pawz
        rm -rf /usr/local/perfcap/settings/.uninstall_pawz
        if [ -h /usr/bin/pawzagent ] ; then
            rm -r /usr/bin/pawzagent
        fi
       relink_uninstall
    fi

    if [ $UNINSTALL_RN -eq 1 ]
    then
        echo "Removing PerfCap.PerfCapRelnotes .."
        rm -rf /usr/local/perfcap/docs
        rm -rf /usr/local/perfcap/settings/.install_rn
        rm -rf /usr/local/perfcap/settings/.uninstall_rn
        relink_uninstall
    fi
    if [ $UNINSTALL_PLAN -eq 1 ]
    then
        echo "Removing PerfCap.PerfCapPlan .."
        rm -f /usr/local/perfcap/bin/ecap_plan
        rm -f /usr/local/perfcap/bin_i386/ecap_plan
        rm -f /usr/local/perfcap/gui/perfcap_main.uid
        rm -f /usr/local/perfcap/gui/perfcap_report.uid
        rm -f /usr/local/perfcap/gui/perfcap_systemview.uid
        rm -f /usr/local/perfcap/gui/perfcap_ioview.uid
        rm -f /usr/local/perfcap/gui/perfcap_model.uid
        rm -f /usr/local/perfcap/gui/perfcap_sys_stats.uid
        rm -f /usr/local/perfcap/gui/perfcap_topview.uid
        rm -f /usr/local/perfcap/man/ecap_plan.1
        rm -rf /usr/local/perfcap/settings/.install_plan
        rm -rf /usr/local/perfcap/settings/.uninstall_plan
        if [ -h /usr/bin/plan ]
        then
            rm -f /usr/bin/plan
        fi
        if [ -h /usr/bin/ecap_plan ]
        then
            rm -f /usr/bin/ecap_plan
        fi
        relink_uninstall
    fi

    if [ $UNINSTALL_AN -eq 1 ]
    then
        echo "Removing PerfCap.PerfCapAnalyze.."
        rm -f /usr/local/perfcap/bin_i386/ecap_analyze
        rm -f /usr/local/perfcap/bin_x64/ecap_analyze
        rm -f /usr/local/perfcap/bin_i386/ecap_analyze_motif
        rm -f /usr/local/perfcap/bin_i386/ecap_graph
        rm -f /usr/local/perfcap/bin_i386/ecap_export
        rm -f /usr/local/perfcap/bin_x64/ecap_export
        rm -f /usr/local/perfcap/bin/ecap_analyze
        rm -f /usr/local/perfcap/bin/ecap_analyze_motif
        rm -f /usr/local/perfcap/bin/ecap_graph
        rm -f /usr/local/perfcap/bin/ecap_export
        rm -f /usr/local/perfcap/bin/ecap_export.sh
        rm -f /usr/local/perfcap/gui/perfcap_di.uid
        rm -rf /usr/local/perfcap/settings/.install_an
        rm -rf /usr/local/perfcap/settings/.uninstall_an
        rm -f /usr/local/perfcap/man/ecap_analyze.1
        if [ -h /usr/bin/ecap_analyze ]
        then
            rm -f /usr/bin/ecap_analyze
        fi
        if [ -h /usr/bin/ecap_analyze_motif ]
        then
            rm -f /usr/bin/ecap_analyze_motif
        fi
        if [ -h /usr/bin/ecap_export ]
        then
            rm -f /usr/bin/ecap_export
        fi
        if [ -h /usr/bin/ecap_graph ]
        then
            rm -f /usr/bin/ecap_graph
        fi
        relink_uninstall
    fi
   if [ $UNINSTALL_DB -eq 1 ]
    then
        echo "Removing PerfCap.PerfCapDb..."
        rm -rf /usr/local/perfcap/db
        rm -f /usr/local/perfcap/settings/.install_db
        rm -f /usr/local/perfcap/settings/.uninstall_db
        relink_uninstall
    fi

    if [ $UNINSTALL_DC -eq 1 ]
    then
       echo "Removing PerfCap.PerfCapMonitor..."
        if [ -x /usr/bin/ecap_monitor ] ; then
           /usr/bin/ecap_monitor -stop
           sleep 1
        fi

    if [ -h /usr/share/man/man1/cpcunix.1 ]
        then
            rm /usr/share/man/man1/cpcunix.1
        fi
        rm -f /usr/local/perfcap/logs/ecp*.log
        rm -f /usr/local/perfcap/bin/ecap_monitor
        rm -f /usr/local/perfcap/bin_i386/ecap_monitor
        rm -f /usr/local/perfcap/bin_x64/ecap_monitor
        rm -f /usr/local/perfcap/bin/ecap_configure
        rm -f /usr/local/perfcap/bin_i386/ecap_configure
        rm -f /usr/local/perfcap/bin_x64/ecap_configure
        rm -f /usr/local/perfcap/man/ecap_monitor.1
        rm -f /usr/local/perfcap/settings/.install_dc
        rm -f /usr/local/perfcap/settings/.uninstall_dc
        rm -f /usr/local/perfcap/man/ecap_monitor.1
        if [ -h /usr/bin/cpcunix ] ; then
           rm -r /usr/bin/cpcunix
        fi
        if [ -h /usr/bin/ecap_monitor ] ; then
           rm -r /usr/bin/ecap_monitor
        fi
        relink_uninstall
    fi
    if [ $IS_COMPLETE -eq 1 ]
    then
         /usr/bin/echo " "
         /usr/bin/echo " Removing init.d files..."
         /sbin/chkconfig --del perfcap
         if [ -f /etc/rc.d/init.d/perfcap ]
         then
            rm -f /etc/rc.d/init.d/perfcap
         fi
         if [ -f /etc/rc.d/perfcap ]
         then
            rm -f /etc/rc.d/perfcap
         fi
    fi
   return
}

remove_selected()
{

  if [ "$OS" = "AIX" ]
   then 
        remove_aix
   fi
   if [ "$OS" = "SunOS" ]
   then
        remove_sun
   fi
   if [ "$OS" = "OSF1" ]
   then
        remove_tru
   fi
   if [ "$OS" = "HP-UX" ]
   then
        remove_hpux
   fi
   if [ "$OS" = "Linux" ]
   then
        ARCH=`uname -m`
        if [ "$ARCH" = "ia64" ]
       then
          remove_linux_ia64
       else
          remove_linux
       fi
   fi
   return
}


relink_uninstall()
{
       cd /usr/local/perfcap/settings

       RELINKED=0
       UNINSTALL_FILES='.uninstall_pawz  .uninstall_dc .uninstall_plan
                 .uninstall_db .uninstall_an .uninstall_rn .uninstall_rt'
       for file in ${UNINSTALL_FILES}
       do
            if  [ -f ${file} ]
            then
               if [ -f /usr/local/perfcap/uninstall.sh ]
               then
                  rm /usr/local/perfcap/uninstall.sh
               fi
               ln -fs /usr/local/perfcap/settings/${file}  \
                           /usr/local/perfcap/uninstall.sh
               RELINKED=1
           fi
     done

     if [ $RELINKED -eq 0 ]
     then
         if [ -f /usr/local/perfcap/uninstall.sh ]
         then
              rm /usr/local/perfcap/uninstall.sh
         fi
     fi
    return
}


 #-------------------------------------- main

  UNINSTALL_RT=0
  UNINSTALL_PAWZ=0
  UNINSTALL_PLAN=0
  UNINSTALL_DB=0
  UNINSTALL_RN=0
  UNINSTALL_DC=0
  UNINSTALL_AN=0
  FOUND=0
  DONE_SEL=0

  IS_SILENT=0
  IS_COMPLETE=0

  SetupEnv

  $ECHO " "
  $ECHO " PerfCap Corporation deinstallation script for UNIX products"
  $ECHO " Copyright (c) 2001-2012, PerfCap Corporation, All Rights Reserved"
  $ECHO " "

  cd "$INSTALL_DIR"
  ACTUAL_INSTALL_DIR="`pwd -P`"
  cd ./data 
  ACTUAL_DATA_DIR="`pwd -P`"


  #----------------------------------------
  # Get Command Line Settings
  #-----------------------------------------

  if [  "$1" = "-silent"  ] || [ "$2" = "-silent" ]
  then
      IS_SILENT=1
  fi
  if [  "$1" = "-complete"  ] || [  "$2" = "-complete"  ]
  then
      IS_COMPLETE=1
  fi

  #----------------------------------------
  # if not silent ask user 
  #-----------------------------------------

  if [ $IS_SILENT -eq 0 ]
  then
     interactive_uninstall
  fi

  #----------------------------------------
  # remove components 
  #-----------------------------------------

  remove_selected

  #----------------------------------------
  # if complete, remove data and installdir 
  #-----------------------------------------

  if  [ $IS_COMPLETE -eq 1 ]
  then
       if [ $IS_SILENT -eq 0 ]
       then
           $ECHO " "
           if [ $USE_ECHO_N -eq 1 ]
           then
              $ECHON " Complete uninstall will remove data files, proceed? (y,n) [n]:  "
           else
              $ECHO " Complete uninstall will remove data files, proceed? (y/n) [n] : \c"
           fi
           read answer
           if [ "$answer" = 'y' ] || [ "$answer" = 'Y' ] || \
            [ "$answer" = "yes" ]  || [ "$answer" = "YES" ]; then
               $ECHO " "
               cd /
               $ECHO " rm -rf $ACTUAL_DATA_DIR"
               rm -rf $ACTUAL_DATA_DIR
               $ECHO  " rm -rf $ACTUAL_INSTALL_DIR"
               rm -rf $ACTUAL_INSTALL_DIR
           else
               IS_COMPLETE=0
           fi
       else
           $ECHO " "
           cd /
           $ECHO " rm -rf $ACTUAL_DATA_DIR"
           rm -rf $ACTUAL_DATA_DIR
           $ECHO  " rm -rf $ACTUAL_INSTALL_DIR"
           rm -rf $ACTUAL_INSTALL_DIR
       fi
  fi

  $ECHO " "
  if  [ $IS_COMPLETE -eq 1 ]; then
     $ECHO "eCAP / PAWZ uninstall complete. [COMPLETE] "
  else
     $ECHO "eCAP / PAWZ uninstall complete. [PARTIAL] "
  fi
  $ECHO " "
  exit

